/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.stats;

import com.newrelic.agent.Agent;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.StatsServiceMetricAggregator;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsEngineImpl;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.stats.StatsWork;
import com.newrelic.api.agent.MetricAggregator;
import java.text.MessageFormat;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class StatsServiceImpl
extends AbstractService
implements StatsService {
    private final MetricAggregator metricAggregator = new StatsServiceMetricAggregator(this);
    private final ConcurrentMap<String, StatsEngineQueue> statsEngineQueues = new ConcurrentHashMap<String, StatsEngineQueue>();
    private volatile StatsEngineQueue defaultStatsEngineQueue;
    private final String defaultAppName = ServiceFactory.getConfigService().getDefaultAgentConfig().getApplicationName();

    public StatsServiceImpl() {
        super(StatsService.class.getSimpleName());
        this.defaultStatsEngineQueue = this.createStatsEngineQueue();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    public void doStatsWork(StatsWork work) {
        String appName = work.getAppName();
        boolean done = false;
        while (!done) {
            done = this.getOrCreateStatsEngineQueue(appName).doStatsWork(work);
        }
    }

    @Override
    public StatsEngine getStatsEngineForHarvest(String appName) {
        StatsEngineQueue oldStatsEngineQueue = this.replaceStatsEngineQueue(appName);
        return oldStatsEngineQueue.getStatsEngineForHarvest();
    }

    @Override
    public MetricAggregator getMetricAggregator() {
        return this.metricAggregator;
    }

    private StatsEngineQueue replaceStatsEngineQueue(String appName) {
        StatsEngineQueue oldStatsEngineQueue = this.getOrCreateStatsEngineQueue(appName);
        StatsEngineQueue newStatsEngineQueue = this.createStatsEngineQueue();
        if (oldStatsEngineQueue == this.defaultStatsEngineQueue) {
            this.defaultStatsEngineQueue = newStatsEngineQueue;
        } else {
            this.statsEngineQueues.put(appName, newStatsEngineQueue);
        }
        return oldStatsEngineQueue;
    }

    private StatsEngineQueue getOrCreateStatsEngineQueue(String appName) {
        StatsEngineQueue statsEngineQueue = this.getStatsEngineQueue(appName);
        if (statsEngineQueue != null) {
            return statsEngineQueue;
        }
        statsEngineQueue = this.createStatsEngineQueue();
        StatsEngineQueue oldStatsEngineQueue = this.statsEngineQueues.putIfAbsent(appName, statsEngineQueue);
        return oldStatsEngineQueue == null ? statsEngineQueue : oldStatsEngineQueue;
    }

    private StatsEngineQueue getStatsEngineQueue(String appName) {
        if (appName == null || appName.equals(this.defaultAppName)) {
            return this.defaultStatsEngineQueue;
        }
        return (StatsEngineQueue)this.statsEngineQueues.get(appName);
    }

    private StatsEngineQueue createStatsEngineQueue() {
        return new StatsEngineQueue();
    }

    private static class StatsEngineQueue {
        private final Lock readLock;
        private final Lock writeLock;
        private final AtomicInteger statsEngineCount = new AtomicInteger();
        private ConcurrentLinkedQueue<StatsEngine> statsEngineQueue = new ConcurrentLinkedQueue();

        private StatsEngineQueue() {
            ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
            this.readLock = lock.readLock();
            this.writeLock = lock.writeLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doStatsWork(StatsWork work) {
            if (this.readLock.tryLock()) {
                try {
                    ConcurrentLinkedQueue<StatsEngine> statsEngineQueue = this.statsEngineQueue;
                    if (statsEngineQueue == null) {
                        boolean bl = false;
                        return bl;
                    }
                    this.doStatsWorkUnderLock(statsEngineQueue, work);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.readLock.unlock();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void doStatsWorkUnderLock(Queue<StatsEngine> statsEngineQueue, StatsWork work) {
            block15: {
                StatsEngine statsEngine = null;
                statsEngine = statsEngineQueue.poll();
                if (statsEngine == null) {
                    statsEngine = this.createStatsEngine();
                    this.statsEngineCount.incrementAndGet();
                }
                work.doWork(statsEngine);
                if (statsEngine == null) break block15;
                try {
                    if (!statsEngineQueue.offer(statsEngine)) {
                        Agent.LOG.warning("Failed to return stats engine to queue");
                    }
                    break block15;
                }
                catch (Exception e) {
                    String msg = MessageFormat.format("Exception returning stats engine to queue: {0}", e);
                    Agent.LOG.warning(msg);
                }
                break block15;
                catch (Exception e) {
                    String msg;
                    try {
                        msg = MessageFormat.format("Exception doing stats work: {0}", e);
                        Agent.LOG.warning(msg);
                        if (statsEngine == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (statsEngine != null) {
                            try {
                                if (!statsEngineQueue.offer(statsEngine)) {
                                    Agent.LOG.warning("Failed to return stats engine to queue");
                                }
                            }
                            catch (Exception e2) {
                                String msg2 = MessageFormat.format("Exception returning stats engine to queue: {0}", e2);
                                Agent.LOG.warning(msg2);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        if (!statsEngineQueue.offer(statsEngine)) {
                            Agent.LOG.warning("Failed to return stats engine to queue");
                        }
                    }
                    catch (Exception e3) {
                        msg = MessageFormat.format("Exception returning stats engine to queue: {0}", e3);
                        Agent.LOG.warning(msg);
                    }
                }
            }
        }

        public StatsEngine getStatsEngineForHarvest() {
            ConcurrentLinkedQueue<StatsEngine> statsEngineQueue;
            this.writeLock.lock();
            try {
                statsEngineQueue = this.statsEngineQueue;
                this.statsEngineQueue = null;
            }
            finally {
                this.writeLock.unlock();
            }
            return this.getStatsEngineForHarvest(statsEngineQueue);
        }

        private StatsEngine getStatsEngineForHarvest(Queue<StatsEngine> statsEngines) {
            StatsEngine harvestStatsEngine = this.createStatsEngine();
            int actualStatsEngineCount = 0;
            for (StatsEngine statsEngine : statsEngines) {
                harvestStatsEngine.mergeStats(statsEngine);
                ++actualStatsEngineCount;
            }
            int expectedStatsEngineCount = this.statsEngineCount.get();
            if (actualStatsEngineCount != expectedStatsEngineCount) {
                String msg = MessageFormat.format("Error draining stats engine queue. Expected: {0} actual: {1}", expectedStatsEngineCount, actualStatsEngineCount);
                Agent.LOG.warning(msg);
            }
            return harvestStatsEngine;
        }

        private StatsEngine createStatsEngine() {
            return new StatsEngineImpl();
        }
    }
}

