/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.async;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.bridge.Token;
import com.newrelic.agent.deps.com.google.common.cache.Cache;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import com.newrelic.agent.deps.com.google.common.cache.RemovalCause;
import com.newrelic.agent.deps.com.google.common.cache.RemovalListener;
import com.newrelic.agent.deps.com.google.common.cache.RemovalNotification;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.util.TimeConversion;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class AsyncTransactionService
extends AbstractService
implements HarvestListener {
    private static final RemovalListener<Object, com.newrelic.api.agent.Token> removalListener = new RemovalListener<Object, com.newrelic.api.agent.Token>(){

        @Override
        public void onRemoval(RemovalNotification<Object, com.newrelic.api.agent.Token> notification) {
            RemovalCause cause = notification.getCause();
            if (cause == RemovalCause.EXPLICIT) {
                Agent.LOG.log(Level.FINEST, "{2}: Key {0} with transaction {1} removed from cache.", notification.getKey(), notification.getValue(), (Object)cause);
            } else {
                Agent.LOG.log(Level.FINE, "{2}: The registered async activity with async context {0} has timed out for transaction {1} and been removed from the cache.", notification.getKey(), notification.getValue(), (Object)cause);
            }
        }
    };
    private static final Cache<Object, com.newrelic.api.agent.Token> PENDING_ACTIVITIES = AsyncTransactionService.makeCache(removalListener);

    public AsyncTransactionService() {
        super(AsyncTransactionService.class.getSimpleName());
        PENDING_ACTIVITIES.invalidateAll();
    }

    private static final Cache<Object, com.newrelic.api.agent.Token> makeCache(RemovalListener<Object, com.newrelic.api.agent.Token> removalListener) {
        long timeoutSec = ServiceFactory.getConfigService().getDefaultAgentConfig().getTokenTimeoutInSec();
        long timeOutMilli = TimeConversion.convertToMilliWithLowerBound(timeoutSec, TimeUnit.SECONDS, 250L);
        return CacheBuilder.newBuilder().expireAfterWrite(timeOutMilli, TimeUnit.MILLISECONDS).removalListener(removalListener).concurrencyLevel(8).build();
    }

    protected void cleanUpPendingTransactions() {
        PENDING_ACTIVITIES.cleanUp();
        Agent.LOG.log(Level.FINER, "Cleaning up the pending activities cache.");
    }

    public boolean putIfAbsent(Object key, com.newrelic.api.agent.Token tx) {
        return PENDING_ACTIVITIES.asMap().putIfAbsent(key, tx) == null;
    }

    public com.newrelic.api.agent.Token extractIfPresent(Object key) {
        return (com.newrelic.api.agent.Token)PENDING_ACTIVITIES.asMap().remove(key);
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
        this.cleanUpPendingTransactions();
    }

    @Deprecated
    public boolean registerAsyncActivity(Object context) {
        Token token;
        Transaction tx = Transaction.getTransaction(false);
        if (tx != null && context != null && (token = tx.getToken()) != null) {
            if (!this.putIfAbsent(context, (com.newrelic.api.agent.Token)token)) {
                token.expire();
            } else {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public boolean startAsyncActivity(Object context) {
        com.newrelic.api.agent.Token token = this.extractIfPresent(context);
        if (token != null) {
            if (TransactionActivity.get() != null && TransactionActivity.get().isStarted()) {
                token.link();
            }
            token.expire();
            return true;
        }
        return false;
    }

    public boolean ignoreIfUnstartedAsyncContext(Object asyncContext) {
        com.newrelic.api.agent.Token token = this.extractIfPresent(asyncContext);
        if (token == null) {
            return false;
        }
        return token.expire();
    }

    protected int cacheSizeForTesting() {
        return PENDING_ACTIVITIES.asMap().size();
    }

    @Override
    public void afterHarvest(String appName) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceFactory.getHarvestService().addHarvestListener(this);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getHarvestService().removeHarvestListener(this);
    }
}

