/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.service.analytics.PriorityAware;
import com.newrelic.agent.tracing.DistributedTraceServiceImpl;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class AnalyticsEvent
implements JSONStreamAware,
PriorityAware {
    private static final Pattern TYPE_VALID = Pattern.compile("^[a-zA-Z0-9:_ ]{1,255}$");
    private static final ThreadLocal<DecimalFormat> FORMATTER = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            DecimalFormat format = new DecimalFormat();
            DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
            if (symbols.getDecimalSeparator() == ',') {
                format.applyLocalizedPattern("#,######");
            } else {
                format.applyPattern("#.######");
            }
            return format;
        }
    };
    final float priority;
    final String type;
    final long timestamp;
    Map<String, Object> userAttributes;

    public AnalyticsEvent(String type, long timestamp) {
        this(type, timestamp, DistributedTraceServiceImpl.nextTruncatedFloat());
    }

    public AnalyticsEvent(String type, long timestamp, float priority) {
        this.type = type;
        this.timestamp = timestamp;
        this.priority = priority;
    }

    @Override
    public abstract void writeJSONString(Writer var1) throws IOException;

    public static boolean isValidType(String type) {
        return type != null && TYPE_VALID.matcher(type).matches();
    }

    public boolean isValid() {
        return AnalyticsEvent.isValidType(this.type);
    }

    public String getType() {
        return this.type;
    }

    @Override
    public boolean decider() {
        return false;
    }

    @Override
    public float getPriority() {
        return this.priority;
    }

    public Map<String, Object> getAttributesCopy() {
        if (this.userAttributes == null) {
            return null;
        }
        return new HashMap<String, Object>(this.userAttributes);
    }
}

