/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.normalization;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.ServerProp;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import com.newrelic.agent.normalization.NormalizationRule;
import com.newrelic.agent.normalization.TransactionSegmentTerms;
import com.newrelic.agent.transport.DataSenderWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class NormalizationRuleFactory {
    public static final String TRANSACTION_SEGMENT_TERMS_KEY = "transaction_segment_terms";
    public static final String URL_RULES_KEY = "url_rules";
    public static final String METRIC_NAME_RULES_KEY = "metric_name_rules";
    public static final String TRANSACTION_NAME_RULES_KEY = "transaction_name_rules";
    private static final List<Map<String, Object>> EMPTY_RULES_DATA = Collections.emptyList();
    private static final List<NormalizationRule> EMPTY_RULES = Collections.emptyList();

    public static List<NormalizationRule> getUrlRules(String appName, Map<String, Object> data) {
        try {
            List<Map<String, Object>> rulesData = NormalizationRuleFactory.getUrlRulesData(appName, data);
            List<NormalizationRule> rules = NormalizationRuleFactory.createRules(appName, rulesData);
            if (rules.isEmpty()) {
                Agent.LOG.warning("The agent did not receive any url rules from the New Relic server.");
            } else {
                String msg = MessageFormat.format("Received {0} url rule(s) for {1}", rules.size(), appName);
                Agent.LOG.fine(msg);
            }
            return rules;
        }
        catch (Exception e) {
            String msg = MessageFormat.format("An error occurred getting url rules for {0} from the New Relic server. This can indicate a problem with the agent rules supplied by the New Relic server.: {1}", appName, e);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.log(Level.FINER, msg, e);
            } else {
                Agent.LOG.log(Level.INFO, msg);
            }
            return EMPTY_RULES;
        }
    }

    public static List<NormalizationRule> getMetricNameRules(String appName, Map<String, Object> data) {
        try {
            List<Map<String, Object>> rulesData = NormalizationRuleFactory.getMetricNameRulesData(appName, data);
            List<NormalizationRule> rules = NormalizationRuleFactory.createRules(appName, rulesData);
            String msg = MessageFormat.format("Received {0} metric name rule(s) for {1}", rules.size(), appName);
            Agent.LOG.fine(msg);
            return rules;
        }
        catch (Exception e) {
            String msg = MessageFormat.format("An error occurred getting metric name rules for {0} from the New Relic server. This can indicate a problem with the agent rules supplied by the New Relic server.: {1}", appName, e);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.log(Level.FINER, msg, e);
            } else {
                Agent.LOG.log(Level.INFO, msg);
            }
            return EMPTY_RULES;
        }
    }

    public static List<NormalizationRule> getTransactionNameRules(String appName, Map<String, Object> data) {
        try {
            List<Map<String, Object>> rulesData = NormalizationRuleFactory.getTransactionNameRulesData(appName, data);
            List<NormalizationRule> rules = NormalizationRuleFactory.createRules(appName, rulesData);
            String msg = MessageFormat.format("Received {0} transaction name rule(s) for {1}", rules.size(), appName);
            Agent.LOG.fine(msg);
            return rules;
        }
        catch (Exception e) {
            String msg = MessageFormat.format("An error occurred getting transaction name rules for {0} from the New Relic server. This can indicate a problem with the agent rules supplied by the New Relic server.: {1}", appName, e);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.log(Level.FINER, msg, e);
            } else {
                Agent.LOG.log(Level.INFO, msg);
            }
            return EMPTY_RULES;
        }
    }

    private static List<Map<String, Object>> getUrlRulesData(String appName, Map<String, Object> data) {
        try {
            Object response = data.get(URL_RULES_KEY);
            if (response == null || DataSenderWriter.nullValue().equals(response)) {
                return EMPTY_RULES_DATA;
            }
            if (response instanceof ServerProp) {
                response = ((ServerProp)response).getValue();
            }
            if (!(response instanceof List)) {
                String msg = MessageFormat.format("Unexpected url rules data for {0}: {1}", appName, response);
                Agent.LOG.finer(msg);
                return EMPTY_RULES_DATA;
            }
            return (List)response;
        }
        catch (Exception e) {
            String msg = MessageFormat.format("An error occurred getting url rules data for {0} from the New Relic server. This can indicate a problem with the agent rules supplied by the New Relic server.: {1}", appName, e);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.log(Level.FINER, msg, e);
            } else {
                Agent.LOG.log(Level.INFO, msg);
            }
            return EMPTY_RULES_DATA;
        }
    }

    private static List<Map<String, Object>> getMetricNameRulesData(String appName, Map<String, Object> data) {
        try {
            Object response = data.get(METRIC_NAME_RULES_KEY);
            if (response == null || DataSenderWriter.nullValue().equals(response)) {
                return EMPTY_RULES_DATA;
            }
            if (response instanceof ServerProp) {
                response = ((ServerProp)response).getValue();
            }
            if (!(response instanceof List)) {
                String msg = MessageFormat.format("Unexpected metric name rules data for {0}: {1}", appName, response);
                Agent.LOG.finer(msg);
                return EMPTY_RULES_DATA;
            }
            return (List)response;
        }
        catch (Exception e) {
            String msg = MessageFormat.format("An error occurred getting metric name rules data for {1} from the New Relic server. This can indicate a problem with the agent rules supplied by the New Relic server.: {2}", appName, e);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.log(Level.FINER, msg, e);
            } else {
                Agent.LOG.log(Level.INFO, msg);
            }
            return EMPTY_RULES_DATA;
        }
    }

    private static List<Map<String, Object>> getTransactionNameRulesData(String appName, Map<String, Object> data) {
        try {
            Object response = data.get(TRANSACTION_NAME_RULES_KEY);
            if (response == null || DataSenderWriter.nullValue().equals(response)) {
                return EMPTY_RULES_DATA;
            }
            if (response instanceof ServerProp) {
                response = ((ServerProp)response).getValue();
            }
            if (!(response instanceof List)) {
                String msg = MessageFormat.format("Unexpected transaction name rules data for {0}: {1}", appName, response);
                Agent.LOG.finer(msg);
                return EMPTY_RULES_DATA;
            }
            return (List)response;
        }
        catch (Exception e) {
            String msg = MessageFormat.format("An error occurred getting transaction name rules data for {1} from the New Relic server. This can indicate a problem with the agent rules supplied by the New Relic server.: {2}", appName, e);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.log(Level.FINER, msg, e);
            } else {
                Agent.LOG.log(Level.INFO, msg);
            }
            return EMPTY_RULES_DATA;
        }
    }

    private static List<NormalizationRule> createRules(String appName, List<Map<String, Object>> rulesData) throws Exception {
        ArrayList<NormalizationRule> rules = new ArrayList<NormalizationRule>();
        for (int i = 0; i < rulesData.size(); ++i) {
            Map<String, Object> ruleData = rulesData.get(i);
            NormalizationRule rule = NormalizationRuleFactory.createRule(ruleData);
            if (rule == null) continue;
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Adding rule for \"{0}\": \"{1}\"", appName, rule);
                Agent.LOG.finer(msg);
            }
            rules.add(rule);
        }
        NormalizationRuleFactory.sortRules(rules);
        return rules;
    }

    private static void sortRules(List<NormalizationRule> rules) {
        Collections.sort(rules, new Comparator<NormalizationRule>(){

            @Override
            public int compare(NormalizationRule lhs, NormalizationRule rhs) {
                Integer lhsOrder = lhs.getOrder();
                Integer rhsOrder = rhs.getOrder();
                return lhsOrder.compareTo(rhsOrder);
            }
        });
    }

    private static NormalizationRule createRule(Map<String, Object> ruleData) {
        Boolean terminateChain;
        Boolean ignore;
        Boolean replaceAll;
        Boolean eachSegment = (Boolean)ruleData.get("each_segment");
        if (eachSegment == null) {
            eachSegment = Boolean.FALSE;
        }
        if ((replaceAll = (Boolean)ruleData.get("replace_all")) == null) {
            replaceAll = Boolean.FALSE;
        }
        if ((ignore = (Boolean)ruleData.get("ignore")) == null) {
            ignore = Boolean.FALSE;
        }
        if ((terminateChain = (Boolean)ruleData.get("terminate_chain")) == null) {
            terminateChain = Boolean.TRUE;
        }
        int order = ((Number)ruleData.get("eval_order")).intValue();
        String matchExpression = (String)ruleData.get("match_expression");
        String replacement = (String)ruleData.get("replacement");
        return new NormalizationRule(matchExpression, replacement, ignore, order, terminateChain, eachSegment, replaceAll);
    }

    public static List<TransactionSegmentTerms> getTransactionSegmentTermRules(String appName, Map<String, Object> data) {
        Object response = data.get(TRANSACTION_SEGMENT_TERMS_KEY);
        if (response instanceof ServerProp) {
            response = ((ServerProp)response).getValue();
        }
        if (response == null || DataSenderWriter.nullValue().equals(response)) {
            return Collections.emptyList();
        }
        if (!(response instanceof List)) {
            String msg = MessageFormat.format("Unexpected transaction segment term rules data for {0}: {1}", appName, response);
            Agent.LOG.finer(msg);
            return Collections.emptyList();
        }
        List segmentTerms = (List)response;
        ArrayList<TransactionSegmentTerms> list = new ArrayList<TransactionSegmentTerms>();
        for (Map map : segmentTerms) {
            List terms = (List)map.get("terms");
            String prefix = (String)map.get("prefix");
            TransactionSegmentTerms tst = new TransactionSegmentTerms(prefix, ImmutableSet.copyOf(terms));
            list.add(tst);
        }
        Agent.LOG.log(Level.FINE, "Received {0} transaction segment rule(s) for {1}", list.size(), appName);
        return list;
    }
}

