/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.logging;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.apache.logging.log4j.LogManager;
import com.newrelic.agent.deps.org.apache.logging.log4j.Logger;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.Appender;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.LoggerContext;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.AbstractAppender;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.ConsoleAppender;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.FileManager;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.Configuration;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.LoggerConfig;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.layout.PatternLayout;
import com.newrelic.agent.deps.org.apache.logging.log4j.message.ParameterizedMessage;
import com.newrelic.agent.logging.FileAppenderFactory;
import com.newrelic.agent.logging.FineFilter;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.logging.Log4jLevel;
import com.newrelic.agent.logging.Log4jMarkers;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

class Log4jLogger
implements IAgentLogger {
    private static final String CONSOLE_APPENDER_NAME = "Console";
    static final String CONVERSION_PATTERN = "%d{MMM d, yyyy HH:mm:ss Z} [%pid %tid] %logger %marker: %m%n";
    private final Logger logger;
    private final Map<String, IAgentLogger> childLoggers = new ConcurrentHashMap<String, IAgentLogger>();

    private Log4jLogger(String name, boolean isAgentRoot) {
        this.logger = LogManager.getLogger(name);
        if (isAgentRoot) {
            LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
            Configuration config = ctx.getConfiguration();
            LoggerConfig loggerConfig = config.getLoggerConfig("");
            loggerConfig.setAdditive(false);
            ctx.updateLoggers();
            FineFilter.getFineFilter().start();
        }
    }

    @Override
    public void severe(String pMessage) {
        this.logger.error(Log4jMarkers.ERROR_MARKER, pMessage);
    }

    @Override
    public void error(String pMessage) {
        this.logger.error(Log4jMarkers.ERROR_MARKER, pMessage);
    }

    @Override
    public void warning(String pMessage) {
        this.logger.warn(Log4jMarkers.WARN_MARKER, pMessage);
    }

    @Override
    public void info(String pMessage) {
        this.logger.info(Log4jMarkers.INFO_MARKER, pMessage);
    }

    @Override
    public void config(String pMessage) {
        this.logger.info(Log4jMarkers.INFO_MARKER, pMessage);
    }

    @Override
    public void fine(String pMessage) {
        this.logger.debug(Log4jMarkers.FINE_MARKER, pMessage);
    }

    @Override
    public void finer(String pMessage) {
        this.logger.debug(Log4jMarkers.FINER_MARKER, pMessage);
    }

    @Override
    public void finest(String pMessage) {
        this.logger.trace(Log4jMarkers.FINEST_MARKER, pMessage);
    }

    @Override
    public void debug(String pMessage) {
        this.logger.debug(Log4jMarkers.DEBUG_MARKER, pMessage);
    }

    @Override
    public void trace(String pMessage) {
        this.logger.trace(Log4jMarkers.TRACE_MARKER, pMessage);
    }

    @Override
    public boolean isFineEnabled() {
        return this.logger.isDebugEnabled() && FineFilter.getFineFilter().isEnabledFor(Level.FINE);
    }

    @Override
    public boolean isFinerEnabled() {
        return this.logger.isDebugEnabled() && FineFilter.getFineFilter().isEnabledFor(Level.FINER);
    }

    @Override
    public boolean isFinestEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isLoggable(Level pLevel) {
        Log4jLevel level = Log4jLevel.getLevel(pLevel);
        return level != null && this.logger.isEnabled(level.getLog4jLevel()) && FineFilter.getFineFilter().isEnabledFor(pLevel);
    }

    @Override
    public void log(Level pLevel, final String pMessage, final Throwable pThrowable) {
        if (this.isLoggable(pLevel)) {
            final Log4jLevel level = Log4jLevel.getLevel(pLevel);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Log4jLogger.this.logger.log(level.getLog4jLevel(), level.getMarker(), pMessage, pThrowable);
                    return null;
                }
            });
        }
    }

    @Override
    public void log(Level pLevel, String pMessage) {
        Log4jLevel level = Log4jLevel.getLevel(pLevel);
        this.logger.log(level.getLog4jLevel(), level.getMarker(), pMessage);
    }

    @Override
    public void log(Level pLevel, String pMessage, Object[] pArgs, Throwable pThrowable) {
        Log4jLevel level = Log4jLevel.getLevel(pLevel);
        ParameterizedMessage message = new ParameterizedMessage(pMessage, pArgs);
        this.logger.log(level.getLog4jLevel(), level.getMarker(), message, pThrowable);
    }

    @Override
    public IAgentLogger getChildLogger(Class<?> pClazz) {
        return this.getChildLogger(pClazz.getName());
    }

    @Override
    public IAgentLogger getChildLogger(String pFullName) {
        Log4jLogger logger = Log4jLogger.create(pFullName, false);
        this.childLoggers.put(pFullName, logger);
        return logger;
    }

    public void setLevel(String level) {
        Log4jLevel newLevel = Log4jLevel.getLevel(level, Log4jLevel.INFO);
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(this.logger.getName());
        loggerConfig.setLevel(newLevel.getLog4jLevel());
        ctx.updateLoggers();
        FineFilter.getFineFilter().setLevel(newLevel.getJavaLevel());
    }

    public String getLevel() {
        if (this.logger.getLevel() == com.newrelic.agent.deps.org.apache.logging.log4j.Level.DEBUG) {
            return FineFilter.getFineFilter().getLevel().toString();
        }
        return this.logger.getLevel().toString();
    }

    public void removeConsoleAppender() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(this.logger.getName());
        Appender consoleAppender = loggerConfig.getAppenders().get(CONSOLE_APPENDER_NAME);
        if (consoleAppender != null) {
            loggerConfig.removeAppender(CONSOLE_APPENDER_NAME);
        }
    }

    public void addConsoleAppender() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(this.logger.getName());
        if (loggerConfig.getAppenders().get(CONSOLE_APPENDER_NAME) != null) {
            return;
        }
        ConsoleAppender consoleAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)((AbstractAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder()).setTarget(ConsoleAppender.Target.SYSTEM_OUT)).setLayout(PatternLayout.newBuilder().withPattern(CONVERSION_PATTERN).build())).setName(CONSOLE_APPENDER_NAME)).setFilter(FineFilter.getFineFilter())).build();
        consoleAppender.start();
        loggerConfig.addAppender(consoleAppender, null, FineFilter.getFineFilter());
        ctx.updateLoggers();
    }

    public void addFileAppender(String fileName, long logLimitBytes, int fileCount, boolean isDaily) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(this.logger.getName());
        if (loggerConfig.getAppenders().get("File") != null) {
            return;
        }
        FileAppenderFactory fileAppenderFactory = new FileAppenderFactory(fileCount, logLimitBytes, fileName, isDaily);
        AbstractOutputStreamAppender<? extends FileManager> fileAppender = fileAppenderFactory.build();
        if (fileAppender == null) {
            return;
        }
        fileAppender.start();
        loggerConfig.addAppender(fileAppender, null, FineFilter.getFineFilter());
        ctx.updateLoggers();
    }

    public static Log4jLogger create(String name, boolean isAgentRoot) {
        return new Log4jLogger(name, isAgentRoot);
    }

    public void log(Level level, String pattern, Object[] msg) {
        if (this.isLoggable(level)) {
            this.log(level, this.getMessage(pattern, msg));
        }
    }

    public void log(Level level, String pattern, Object part1) {
        if (this.isLoggable(level)) {
            this.log(level, this.getMessage(pattern, part1));
        }
    }

    public void log(Level level, String pattern, Object part1, Object part2) {
        if (this.isLoggable(level)) {
            this.log(level, this.getMessage(pattern, part1, part2));
        }
    }

    public void log(Level level, String pattern, Object part1, Object part2, Object part3) {
        if (this.isLoggable(level)) {
            this.log(level, this.getMessage(pattern, part1, part2, part3));
        }
    }

    public void log(Level level, String pattern, Object part1, Object part2, Object part3, Object part4) {
        if (this.isLoggable(level)) {
            this.log(level, this.getMessage(pattern, part1, part2, part3, part4));
        }
    }

    public void log(Level level, String pattern, Object part1, Object part2, Object part3, Object part4, Object part5) {
        if (this.isLoggable(level)) {
            this.log(level, this.getMessage(pattern, part1, part2, part3, part4, part5));
        }
    }

    public void log(Level level, String pattern, Object part1, Object part2, Object part3, Object part4, Object part5, Object part6) {
        if (this.isLoggable(level)) {
            this.log(level, this.getMessage(pattern, part1, part2, part3, part4, part5, part6));
        }
    }

    public void log(Level level, String pattern, Object part1, Object part2, Object part3, Object part4, Object part5, Object part6, Object part7) {
        if (this.isLoggable(level)) {
            this.log(level, this.getMessage(pattern, part1, part2, part3, part4, part5, part6, part7));
        }
    }

    public void log(Level level, String pattern, Object part1, Object part2, Object part3, Object part4, Object part5, Object part6, Object part7, Object ... otherParts) {
        if (this.isLoggable(level)) {
            Object[] parts = this.merge(otherParts, part1, part2, part3, part4, part5, part6, part7);
            this.log(level, this.getMessage(pattern, parts));
        }
    }

    public void log(Level level, Throwable t, String pattern, Object[] msg) {
        if (this.isLoggable(level)) {
            this.log(level, this.getMessage(pattern, msg), t);
        }
    }

    public void log(Level level, Throwable t, String pattern) {
        if (this.isLoggable(level)) {
            this.log(level, this.getMessage(pattern, new Object[0]), t);
        }
    }

    public void log(Level level, Throwable t, String pattern, Object part1) {
        if (this.isLoggable(level)) {
            this.log(level, this.getMessage(pattern, part1), t);
        }
    }

    public void log(Level level, Throwable t, String pattern, Object part1, Object part2) {
        if (this.isLoggable(level)) {
            this.log(level, this.getMessage(pattern, part1, part2), t);
        }
    }

    public void log(Level level, Throwable t, String pattern, Object part1, Object part2, Object part3) {
        if (this.isLoggable(level)) {
            this.log(level, this.getMessage(pattern, part1, part2, part3), t);
        }
    }

    public void log(Level level, Throwable t, String pattern, Object part1, Object part2, Object part3, Object part4) {
        if (this.isLoggable(level)) {
            this.log(level, this.getMessage(pattern, part1, part2, part3, part4), t);
        }
    }

    public void log(Level level, Throwable t, String pattern, Object part1, Object part2, Object part3, Object part4, Object part5) {
        if (this.isLoggable(level)) {
            this.log(level, this.getMessage(pattern, part1, part2, part3, part4, part5), t);
        }
    }

    public void log(Level level, Throwable t, String pattern, Object part1, Object part2, Object part3, Object part4, Object part5, Object part6) {
        if (this.isLoggable(level)) {
            this.log(level, this.getMessage(pattern, part1, part2, part3, part4, part5, part6), t);
        }
    }

    public void log(Level level, Throwable t, String pattern, Object part1, Object part2, Object part3, Object part4, Object part5, Object part6, Object part7) {
        if (this.isLoggable(level)) {
            this.log(level, this.getMessage(pattern, part1, part2, part3, part4, part5, part6, part7), t);
        }
    }

    public void log(Level level, Throwable t, String pattern, Object part1, Object part2, Object part3, Object part4, Object part5, Object part6, Object part7, Object ... otherParts) {
        if (this.isLoggable(level)) {
            Object[] parts = this.merge(otherParts, part1, part2, part3, part4, part5, part6, part7);
            this.log(level, this.getMessage(pattern, parts), t);
        }
    }

    private String getMessage(String pattern, Object ... parts) {
        return parts == null || parts.length == 0 || pattern == null ? pattern : MessageFormat.format(pattern, this.formatValues(parts));
    }

    private Object[] formatValues(Object[] parts) {
        Object[] strings = new Object[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            strings[i] = this.formatValue(parts[i]);
        }
        return strings;
    }

    private Object formatValue(Object obj) {
        if (obj instanceof Class) {
            return ((Class)obj).getName();
        }
        if (obj instanceof Throwable) {
            return obj.toString();
        }
        return obj;
    }

    private Object[] merge(Object[] otherParts, Object ... firstParameters) {
        int otherPartsLength = otherParts != null ? otherParts.length : 0;
        Object[] mergedArray = new Object[firstParameters.length + otherPartsLength];
        System.arraycopy(firstParameters, 0, mergedArray, 0, firstParameters.length);
        if (otherPartsLength > 0) {
            System.arraycopy(otherParts, 0, mergedArray, firstParameters.length, otherPartsLength);
        }
        return mergedArray;
    }

    public void logToChild(String childName, Level level, String pattern, Object part1, Object part2, Object part3, Object part4) {
        if (this.isLoggable(level)) {
            IAgentLogger logger = this.childLoggers.get(childName);
            if (logger == null) {
                logger = Agent.LOG;
            }
            logger.log(level, pattern, part1, part2, part3, part4);
        }
    }
}

