/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.weaver.extension;

import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.ExtensionHolder;
import com.newrelic.agent.bridge.ExtensionHolderFactory;
import com.newrelic.agent.deps.com.google.common.cache.Cache;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;

public class ExtensionHolderFactoryImpl
implements ExtensionHolderFactory {
    public <T> ExtensionHolder<T> build() {
        return new ExtensionHolderImpl();
    }

    public static class ExtensionHolderImpl<T>
    implements ExtensionHolder<T> {
        private final Cache<Object, T> instanceCache = CacheBuilder.newBuilder().concurrencyLevel(32).weakKeys().build();

        public T getAndRemoveExtension(Object instance) {
            return (T)this.instanceCache.asMap().remove(instance);
        }

        public T getExtension(Object instance, Callable<T> valueLoader) {
            try {
                return this.instanceCache.get(instance, valueLoader);
            }
            catch (ExecutionException e) {
                AgentBridge.getAgent().getLogger().log(Level.FINE, (Throwable)e, "Unable to load extension class for {0}", (Object)instance.getClass().getName());
                throw new RuntimeException(e);
            }
        }
    }
}

