/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.context;

import com.newrelic.agent.bridge.Instrumentation;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.commons.GeneratorAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.tracing.BridgeUtils;
import com.newrelic.agent.util.asm.BytecodeGenProxyBuilder;
import java.util.HashSet;
import java.util.Set;

public class CurrentTransactionRewriter {
    public static ClassVisitor rewriteCurrentTransactionReferences(ClassVisitor cv, ClassReader reader, InstrumentationContext context) {
        final Set<Method> localTransactionMethods = CurrentTransactionRewriter.getLocalTransactionMethods(reader);
        if (localTransactionMethods.isEmpty()) {
            return cv;
        }
        return new ClassVisitor(458752, cv){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                Method method = new Method(name, desc);
                if (localTransactionMethods.contains(method)) {
                    mv = new RewriteVisitor(mv, access, name, desc);
                }
                return mv;
            }
        };
    }

    private static boolean isCurrentTransactionReference(int opcode, String owner, String name) {
        return 178 == opcode && BridgeUtils.isTransactionType(owner) && "CURRENT".equals(name);
    }

    private static boolean isCurrentTxOrNullReference(int opcode, String owner, String name) {
        return 178 == opcode && BridgeUtils.isTransactionType(owner) && "CURRENT_OR_NULL".equals(name);
    }

    private static boolean isCurrentTransactionMethod(String owner, String name) {
        return BridgeUtils.isAgentType(owner) && "getTransaction".equals(name);
    }

    private static Set<Method> getLocalTransactionMethods(ClassReader reader) {
        final HashSet<Method> methods = new HashSet<Method>();
        ClassVisitor cv = new ClassVisitor(458752){

            @Override
            public MethodVisitor visitMethod(int access, final String methodName, final String methodDesc, String signature, String[] exceptions) {
                return new MethodVisitor(458752){

                    @Override
                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        if (CurrentTransactionRewriter.isCurrentTransactionReference(opcode, owner, name) || CurrentTransactionRewriter.isCurrentTxOrNullReference(opcode, owner, name)) {
                            methods.add(new Method(methodName, methodDesc));
                        }
                    }
                };
            }
        };
        reader.accept(cv, 6);
        return methods;
    }

    private static class RewriteVisitor
    extends GeneratorAdapter {
        protected RewriteVisitor(MethodVisitor mv, int access, String name, String desc) {
            super(458752, mv, access, name, desc);
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (CurrentTransactionRewriter.isCurrentTransactionReference(opcode, owner, name)) {
                this.getStatic(BridgeUtils.AGENT_BRIDGE_TYPE, "instrumentation", BridgeUtils.INSTRUMENTATION_TYPE);
                BytecodeGenProxyBuilder.newBuilder(Instrumentation.class, this, false).build().getTransaction();
            } else if (CurrentTransactionRewriter.isCurrentTxOrNullReference(opcode, owner, name)) {
                this.getStatic(BridgeUtils.AGENT_BRIDGE_TYPE, "instrumentation", BridgeUtils.INSTRUMENTATION_TYPE);
                BytecodeGenProxyBuilder.newBuilder(Instrumentation.class, this, false).build().getTransactionOrNull();
            } else {
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        }
    }
}

