/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.org.apache.logging.log4j.core.lookup;

import com.newrelic.agent.deps.org.apache.logging.log4j.Logger;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.LogEvent;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.ConfigurationAware;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.plugins.util.PluginType;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.lookup.AbstractConfigurationAwareLookup;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.lookup.ContextMapLookup;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.lookup.DateLookup;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.lookup.EnvironmentLookup;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.lookup.JavaLookup;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.lookup.Log4jLookup;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.lookup.MainMapLookup;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.lookup.MapLookup;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.lookup.MarkerLookup;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.lookup.StrLookup;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.lookup.SystemPropertiesLookup;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.util.Loader;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.util.ReflectionUtil;
import com.newrelic.agent.deps.org.apache.logging.log4j.status.StatusLogger;
import com.newrelic.agent.deps.org.apache.logging.log4j.util.Constants;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Interpolator
extends AbstractConfigurationAwareLookup {
    private static final String LOOKUP_KEY_WEB = "web";
    private static final String LOOKUP_KEY_JNDI = "jndi";
    private static final String LOOKUP_KEY_JVMRUNARGS = "jvmrunargs";
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final char PREFIX_SEPARATOR = ':';
    private final Map<String, StrLookup> strLookupMap = new HashMap<String, StrLookup>();
    private final StrLookup defaultLookup;

    public Interpolator(StrLookup defaultLookup) {
        this(defaultLookup, null);
    }

    public Interpolator(StrLookup defaultLookup, List<String> pluginPackages) {
        this.defaultLookup = defaultLookup == null ? new MapLookup(new HashMap<String, String>()) : defaultLookup;
        PluginManager manager = new PluginManager("Lookup");
        manager.collectPlugins(pluginPackages);
        Map<String, PluginType<?>> plugins = manager.getPlugins();
        for (Map.Entry<String, PluginType<?>> entry : plugins.entrySet()) {
            try {
                Class<StrLookup> clazz = entry.getValue().getPluginClass().asSubclass(StrLookup.class);
                this.strLookupMap.put(entry.getKey(), ReflectionUtil.instantiate(clazz));
            }
            catch (Throwable t) {
                this.handleError(entry.getKey(), t);
            }
        }
    }

    public Interpolator() {
        this((Map<String, String>)null);
    }

    public Interpolator(Map<String, String> properties) {
        this.defaultLookup = new MapLookup(properties == null ? new HashMap() : properties);
        this.strLookupMap.put("log4j", new Log4jLookup());
        this.strLookupMap.put("sys", new SystemPropertiesLookup());
        this.strLookupMap.put("env", new EnvironmentLookup());
        this.strLookupMap.put("main", MainMapLookup.MAIN_SINGLETON);
        this.strLookupMap.put("marker", new MarkerLookup());
        this.strLookupMap.put("java", new JavaLookup());
        try {
            this.strLookupMap.put(LOOKUP_KEY_JNDI, Loader.newCheckedInstanceOf("com.newrelic.agent.deps.org.apache.logging.log4j.core.lookup.JndiLookup", StrLookup.class));
        }
        catch (Exception | LinkageError e) {
            this.handleError(LOOKUP_KEY_JNDI, e);
        }
        try {
            this.strLookupMap.put(LOOKUP_KEY_JVMRUNARGS, Loader.newCheckedInstanceOf("com.newrelic.agent.deps.org.apache.logging.log4j.core.lookup.JmxRuntimeInputArgumentsLookup", StrLookup.class));
        }
        catch (Exception | LinkageError e) {
            this.handleError(LOOKUP_KEY_JVMRUNARGS, e);
        }
        this.strLookupMap.put("date", new DateLookup());
        this.strLookupMap.put("ctx", new ContextMapLookup());
        if (Constants.IS_WEB_APP) {
            try {
                this.strLookupMap.put(LOOKUP_KEY_WEB, Loader.newCheckedInstanceOf("com.newrelic.agent.deps.org.apache.logging.log4j.web.WebLookup", StrLookup.class));
            }
            catch (Exception ignored) {
                this.handleError(LOOKUP_KEY_WEB, ignored);
            }
        } else {
            LOGGER.debug("Not in a ServletContext environment, thus not loading WebLookup plugin.");
        }
    }

    public Map<String, StrLookup> getStrLookupMap() {
        return this.strLookupMap;
    }

    private void handleError(String lookupKey, Throwable t) {
        switch (lookupKey) {
            case "jndi": {
                LOGGER.warn("JNDI lookup class is not available because this JRE does not support JNDI. JNDI string lookups will not be available, continuing configuration. Ignoring " + t);
                break;
            }
            case "jvmrunargs": {
                LOGGER.warn("JMX runtime input lookup class is not available because this JRE does not support JMX. JMX lookups will not be available, continuing configuration. Ignoring " + t);
                break;
            }
            case "web": {
                LOGGER.info("Log4j appears to be running in a Servlet environment, but there's no log4j-web module available. If you want better web container support, please add the log4j-web JAR to your web archive or server lib directory.");
                break;
            }
            default: {
                LOGGER.error("Unable to create Lookup for {}", (Object)lookupKey, (Object)t);
            }
        }
    }

    @Override
    public String lookup(LogEvent event, String var) {
        if (var == null) {
            return null;
        }
        int prefixPos = var.indexOf(58);
        if (prefixPos >= 0) {
            String prefix = var.substring(0, prefixPos).toLowerCase(Locale.US);
            String name = var.substring(prefixPos + 1);
            StrLookup lookup = this.strLookupMap.get(prefix);
            if (lookup instanceof ConfigurationAware) {
                ((ConfigurationAware)((Object)lookup)).setConfiguration(this.configuration);
            }
            String value = null;
            if (lookup != null) {
                String string = value = event == null ? lookup.lookup(name) : lookup.lookup(event, name);
            }
            if (value != null) {
                return value;
            }
            var = var.substring(prefixPos + 1);
        }
        if (this.defaultLookup != null) {
            return event == null ? this.defaultLookup.lookup(var) : this.defaultLookup.lookup(event, var);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.strLookupMap.keySet()) {
            if (sb.length() == 0) {
                sb.append('{');
            } else {
                sb.append(", ");
            }
            sb.append(name);
        }
        if (sb.length() > 0) {
            sb.append('}');
        }
        return sb.toString();
    }
}

