/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.com.google.common.io;

import com.newrelic.agent.deps.com.google.common.annotations.Beta;
import com.newrelic.agent.deps.com.google.common.annotations.GwtIncompatible;
import com.newrelic.agent.deps.com.google.common.base.Preconditions;
import com.newrelic.agent.deps.org.checkerframework.checker.nullness.compatqual.NullableDecl;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

@Beta
@GwtIncompatible
public final class PatternFilenameFilter
implements FilenameFilter {
    private final Pattern pattern;

    public PatternFilenameFilter(String patternStr) {
        this(Pattern.compile(patternStr));
    }

    public PatternFilenameFilter(Pattern pattern) {
        this.pattern = Preconditions.checkNotNull(pattern);
    }

    @Override
    public boolean accept(@NullableDecl File dir, String fileName) {
        return this.pattern.matcher(fileName).matches();
    }
}

