/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class SystemPropertyProvider {
    private static final String NEW_RELIC_PREFIX_ENV = "NEW_RELIC_";
    private static final String LICENSE_KEY_ENV = "NEW_RELIC_LICENSE_KEY";
    private static final String APP_NAME_ENV = "NEW_RELIC_APP_NAME";
    private static final String LOG_ENV = "NEW_RELIC_LOG";
    private static final String HOST_ENV = "NEW_RELIC_HOST";
    private static final String HOST_DISPLAY_NAME_ENV = "NEW_RELIC_PROCESS_HOST_DISPLAY_NAME";
    private static final String SECURITY_POLICIES_TOKEN_ENV = "NEW_RELIC_SECURITY_POLICIES_TOKEN";
    private static final String LICENSE_KEY = "newrelic.config.license_key";
    private static final String SECURITY_POLICIES_TOKEN = "newrelic.config.security_policies_token";
    private static final String APP_NAME = "newrelic.config.app_name";
    private static final String LOG_FILE_NAME = "newrelic.config.log_file_name";
    private static final String HOST = "newrelic.config.host";
    private static final String HOST_DISPLAY_NAME = "newrelic.config.process_host.display_name";
    private static final String NEW_RELIC_SYSTEM_PROPERTY_ROOT = "newrelic.";
    private final Map<String, String> envVars;
    private final Map<String, String> envVarToSystemPropKeyMap;
    private final Map<String, String> newRelicSystemProps;
    private final Map<String, Object> newRelicPropsWithoutPrefix;
    private final Map<String, Object> newRelicEnvVarsWithoutPrefix;
    private final SystemProps systemProps;

    public SystemPropertyProvider() {
        this(SystemProps.getSystemProps());
    }

    public SystemPropertyProvider(SystemProps sysProps) {
        this.systemProps = sysProps;
        this.envVars = this.initEnvVariables();
        this.envVarToSystemPropKeyMap = this.initEnvVarToSystemPropMap();
        this.newRelicSystemProps = this.initNewRelicSystemProperties();
        this.newRelicPropsWithoutPrefix = this.createNewRelicSystemPropertiesWithoutPrefix();
        this.newRelicEnvVarsWithoutPrefix = this.createNewRelicEnvVarsWithoutPrefix();
    }

    private Map<String, String> initEnvVariables() {
        HashMap<String, String> envVars = new HashMap<String, String>();
        envVars.put(LICENSE_KEY, this.getenv(LICENSE_KEY_ENV));
        envVars.put(APP_NAME, this.getenv(APP_NAME_ENV));
        envVars.put(LOG_FILE_NAME, this.getenv(LOG_ENV));
        envVars.put(HOST, this.getenv(HOST_ENV));
        envVars.put(HOST_DISPLAY_NAME, this.getenv(HOST_DISPLAY_NAME_ENV));
        envVars.put(SECURITY_POLICIES_TOKEN, this.getenv(SECURITY_POLICIES_TOKEN_ENV));
        envVars.put("newrelic.config.distributed_tracing.enabled", this.getenv("NEW_RELIC_DISTRIBUTED_TRACING_ENABLED"));
        envVars.put("newrelic.config.span_events.enabled", this.getenv("NEW_RELIC_SPAN_EVENTS_ENABLED"));
        return envVars;
    }

    private Map<String, String> initEnvVarToSystemPropMap() {
        HashMap<String, String> envVars = new HashMap<String, String>();
        envVars.put(LICENSE_KEY_ENV, LICENSE_KEY);
        envVars.put(APP_NAME_ENV, APP_NAME);
        envVars.put(LOG_ENV, LOG_FILE_NAME);
        envVars.put(HOST_ENV, HOST);
        envVars.put(HOST_DISPLAY_NAME_ENV, HOST_DISPLAY_NAME);
        envVars.put(SECURITY_POLICIES_TOKEN_ENV, SECURITY_POLICIES_TOKEN);
        envVars.put("NEW_RELIC_DISTRIBUTED_TRACING_ENABLED", "newrelic.config.distributed_tracing.enabled");
        envVars.put("NEW_RELIC_SPAN_EVENTS_ENABLED", "newrelic.config.span_events.enabled");
        return envVars;
    }

    private Map<String, String> initNewRelicSystemProperties() {
        HashMap<String, String> nrProps = new HashMap<String, String>();
        try {
            for (Map.Entry<Object, Object> entry : this.systemProps.getAllSystemProperties().entrySet()) {
                String key = entry.getKey().toString();
                if (!key.startsWith(NEW_RELIC_SYSTEM_PROPERTY_ROOT)) continue;
                String val = entry.getValue().toString();
                nrProps.put(key, val);
            }
        }
        catch (SecurityException t) {
            Agent.LOG.log(Level.FINE, "Unable to get system properties");
        }
        return Collections.unmodifiableMap(nrProps);
    }

    private Map<String, Object> createNewRelicSystemPropertiesWithoutPrefix() {
        HashMap<String, Object> nrProps = new HashMap<String, Object>();
        this.addNewRelicSystemProperties(nrProps, this.systemProps.getAllSystemProperties());
        return Collections.unmodifiableMap(nrProps);
    }

    private Map<String, Object> createNewRelicEnvVarsWithoutPrefix() {
        HashMap<String, Object> nrEnv = new HashMap<String, Object>();
        this.addNewRelicEnvProperties(nrEnv, this.systemProps.getAllEnvProperties());
        return Collections.unmodifiableMap(nrEnv);
    }

    private void addNewRelicSystemProperties(Map<String, Object> nrProps, Properties allSysProps) {
        for (Map.Entry<Object, Object> entry : allSysProps.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("newrelic.config.")) continue;
            this.addPropertyWithoutSystemPropRoot(nrProps, key, entry.getValue().toString());
        }
    }

    private void addNewRelicEnvProperties(Map<String, Object> nrProps, Map<String, String> allEnvVars) {
        for (Map.Entry<String, String> entry : allEnvVars.entrySet()) {
            String envVar = entry.getKey();
            if (envVar.startsWith(NEW_RELIC_PREFIX_ENV)) {
                String envVarNameToReplace = this.envVarToSystemPropKeyMap.get(envVar);
                if (envVarNameToReplace != null) {
                    this.addPropertyWithoutSystemPropRoot(nrProps, envVarNameToReplace, entry.getValue());
                    continue;
                }
                this.addPropertyWithoutEnvPrefix(nrProps, envVar.toLowerCase(), entry.getValue());
                continue;
            }
            if (!envVar.startsWith("newrelic.config.")) continue;
            this.addPropertyWithoutSystemPropRoot(nrProps, envVar, entry.getValue());
        }
    }

    private void addPropertyWithoutEnvPrefix(Map<String, Object> nrprops, String key, Object value) {
        nrprops.put(key.substring(NEW_RELIC_PREFIX_ENV.length()), value);
    }

    private void addPropertyWithoutSystemPropRoot(Map<String, Object> nrProps, String key, Object value) {
        nrProps.put(key.substring("newrelic.config.".length()), value);
    }

    public String getEnvironmentVariable(String key) {
        String propVal = this.envVars.get(key);
        if (propVal != null) {
            return propVal;
        }
        return this.getenv(key);
    }

    private String getenv(String key) {
        String val = this.systemProps.getenv(key);
        if (val != null) {
            return val;
        }
        String removeConfigKey = key.replace("newrelic.config", "new.relic");
        return System.getenv(this.addNewRelicEnvVarPrefix(removeConfigKey));
    }

    private String addNewRelicEnvVarPrefix(String key) {
        String envVarKey = key.replaceAll("[.-]", "_").toUpperCase();
        return envVarKey;
    }

    public String getSystemProperty(String prop) {
        return this.systemProps.getSystemProperty(prop);
    }

    public Map<String, String> getNewRelicSystemProperties() {
        return this.newRelicSystemProps;
    }

    public Map<String, Object> getNewRelicPropertiesWithoutPrefix() {
        return this.newRelicPropsWithoutPrefix;
    }

    public Map<String, Object> getNewRelicEnvVarsWithoutPrefix() {
        return this.newRelicEnvVarsWithoutPrefix;
    }

    protected static abstract class SystemProps {
        protected SystemProps() {
        }

        static SystemProps getSystemProps() {
            try {
                System.getProperties().get("test");
                System.getenv("test");
                return new SystemProps(){

                    @Override
                    String getSystemProperty(String prop) {
                        return System.getProperty(prop);
                    }

                    @Override
                    String getenv(String key) {
                        return System.getenv(key);
                    }

                    @Override
                    Properties getAllSystemProperties() {
                        return System.getProperties();
                    }

                    @Override
                    Map<String, String> getAllEnvProperties() {
                        return System.getenv();
                    }
                };
            }
            catch (SecurityException e) {
                Agent.LOG.error("Unable to access system properties because of a security exception.");
                return new SystemProps(){

                    @Override
                    String getSystemProperty(String prop) {
                        return null;
                    }

                    @Override
                    String getenv(String key) {
                        return null;
                    }

                    @Override
                    Properties getAllSystemProperties() {
                        return new Properties();
                    }

                    @Override
                    Map<String, String> getAllEnvProperties() {
                        return Collections.emptyMap();
                    }
                };
            }
        }

        abstract String getSystemProperty(String var1);

        abstract String getenv(String var1);

        abstract Properties getAllSystemProperties();

        abstract Map<String, String> getAllEnvProperties();
    }
}

