/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.yaml.snakeyaml.Loader;
import com.newrelic.agent.deps.org.yaml.snakeyaml.Yaml;
import com.newrelic.agent.deps.org.yaml.snakeyaml.constructor.Construct;
import com.newrelic.agent.deps.org.yaml.snakeyaml.constructor.Constructor;
import com.newrelic.agent.deps.org.yaml.snakeyaml.nodes.Node;
import com.newrelic.agent.deps.org.yaml.snakeyaml.nodes.SequenceNode;
import com.newrelic.agent.errors.ExceptionHandlerSignature;
import com.newrelic.agent.instrumentation.methodmatchers.InvalidMethodDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class AgentConfigHelper {
    public static final String NEWRELIC_ENVIRONMENT = "newrelic.environment";
    private static final String JAVA_ENVIRONMENT = "JAVA_ENV";
    private static final String PRODUCTION_ENVIRONMENT = "production";

    public static Map<String, Object> getConfigurationFileSettings(File configFile) throws Exception {
        try (FileInputStream is = new FileInputStream(configFile);){
            Map<String, Object> map = AgentConfigHelper.parseConfiguration(is);
            return map;
        }
    }

    public static Map<String, Object> parseConfiguration(InputStream is) throws Exception {
        String env = AgentConfigHelper.getEnvironment();
        try {
            Map allConfig = (Map)AgentConfigHelper.createYaml().load(new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)));
            if (allConfig == null) {
                Agent.LOG.info("The configuration file is empty");
                return Collections.emptyMap();
            }
            Map props = (Map)allConfig.get(env);
            if (props == null) {
                props = (Map)allConfig.get("common");
            }
            if (props == null) {
                throw new Exception(MessageFormat.format("Unable to find configuration named {0}", env));
            }
            return props;
        }
        catch (Exception e) {
            Agent.LOG.log(Level.SEVERE, MessageFormat.format("Unable to parse configuration file. Please validate the yaml: {0}", e.toString()), e);
            throw e;
        }
    }

    private static String getEnvironment() {
        try {
            String env = System.getProperty(NEWRELIC_ENVIRONMENT);
            env = env == null ? System.getenv(JAVA_ENVIRONMENT) : env;
            return env == null ? PRODUCTION_ENVIRONMENT : env;
        }
        catch (Throwable t) {
            return PRODUCTION_ENVIRONMENT;
        }
    }

    private static Yaml createYaml() {
        ExtensionConstructor constructor = new ExtensionConstructor();
        Loader loader = new Loader(constructor);
        return new Yaml(loader);
    }

    private static class ExtensionConstructor
    extends Constructor {
        public ExtensionConstructor() {
            this.yamlConstructors.put("!exception_handler", new Construct(){

                @Override
                public Object construct(Node node) {
                    List args = ExtensionConstructor.this.constructSequence((SequenceNode)node);
                    try {
                        return new ExceptionHandlerSignature((String)args.get(0), (String)args.get(1), (String)args.get(2));
                    }
                    catch (InvalidMethodDescriptor e) {
                        return e;
                    }
                }
            });
        }
    }
}

