/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HeadersUtil;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.parser.JSONParser;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.ServiceUtils;
import com.newrelic.api.agent.InboundHeaders;
import java.util.logging.Level;

public class InboundHeaderState {
    private static final String CONTENT_LENGTH_REQUEST_HEADER = "Content-Length";
    private static final String NEWRELIC_ID_HEADER_SEPARATOR = "#";
    private static final int CURRENT_SYNTHETICS_VERSION = 1;
    private final Transaction tx;
    private final InboundHeaders inboundHeaders;
    private final CatState catState;
    private final SyntheticsState synState;

    public InboundHeaderState(Transaction tx, InboundHeaders inboundHeaders) {
        this.tx = tx;
        this.inboundHeaders = inboundHeaders;
        boolean includeNewRelicHeader = ServiceFactory.getConfigService().getDefaultAgentConfig().getDistributedTracingConfig().isIncludeNewRelicHeader();
        if (inboundHeaders == null) {
            this.synState = SyntheticsState.NONE;
            this.catState = CatState.NONE;
        } else {
            this.synState = this.parseSyntheticsHeader();
            if (tx.getAgentConfig().getDistributedTracingConfig().isEnabled() && tx.getSpanProxy().getInboundDistributedTracePayload() == null) {
                this.parseDistributedTraceHeaders();
                this.catState = CatState.NONE;
            } else {
                this.catState = tx.getCrossProcessConfig().isCrossApplicationTracing() ? this.parseCatHeaders() : CatState.NONE;
            }
        }
    }

    public String getUnparsedSyntheticsHeader() {
        String result = null;
        if (this.inboundHeaders != null) {
            result = HeadersUtil.getSyntheticsHeader(this.inboundHeaders);
        }
        return result;
    }

    private SyntheticsState parseSyntheticsHeader() {
        SyntheticsState result;
        String synHeader = this.getUnparsedSyntheticsHeader();
        if (synHeader == null || synHeader.length() == 0) {
            return SyntheticsState.NONE;
        }
        JSONArray arr = this.getJSONArray(synHeader);
        if (arr == null || arr.size() == 0) {
            Agent.LOG.log(Level.FINE, "Synthetic transaction tracing failed: unable to decode header in transaction {0}.", this.tx);
            return SyntheticsState.NONE;
        }
        Agent.LOG.log(Level.FINEST, "Decoded synthetics header => {0} in transaction {1}", arr, this.tx);
        Integer version = null;
        try {
            version = Integer.parseInt(arr.get(0).toString());
        }
        catch (NumberFormatException nfe) {
            Agent.LOG.log(Level.FINEST, "Could not determine synthetics version. Value => {0}. Class => {1}.", arr.get(0), arr.get(0).getClass());
            return SyntheticsState.NONE;
        }
        if (version > 1) {
            Agent.LOG.log(Level.FINE, "Synthetic transaction tracing failed: invalid version {0} in transaction {1}", version, this.tx);
            return SyntheticsState.NONE;
        }
        try {
            result = new SyntheticsState(version, (Number)arr.get(1), (String)arr.get(2), (String)arr.get(3), (String)arr.get(4));
        }
        catch (RuntimeException rex) {
            Agent.LOG.log(Level.FINE, "Synthetic transaction tracing failed: while parsing header: {0}: {1} in transaction {2}", rex.getClass().getSimpleName(), rex.getLocalizedMessage(), this.tx);
            result = SyntheticsState.NONE;
        }
        return result;
    }

    private CatState parseCatHeaders() {
        String clientCrossProcessID = HeadersUtil.getIdHeader(this.inboundHeaders);
        if (clientCrossProcessID == null || this.tx.isIgnore()) {
            return CatState.NONE;
        }
        if (!this.tx.getCrossProcessConfig().isCrossApplicationTracing()) {
            return CatState.NONE;
        }
        if (!this.isClientCrossProcessIdTrusted(clientCrossProcessID)) {
            return CatState.NONE;
        }
        Agent.LOG.log(Level.FINEST, "Client cross process id is {0} in transaction {1} ", clientCrossProcessID, this.tx);
        String transactionHeader = HeadersUtil.getTransactionHeader(this.inboundHeaders);
        JSONArray arr = this.getJSONArray(transactionHeader);
        if (arr == null) {
            return new CatState(clientCrossProcessID, null, Boolean.FALSE, null, null);
        }
        return new CatState(clientCrossProcessID, arr.size() >= 1 ? (String)arr.get(0) : null, arr.size() >= 2 ? (Boolean)arr.get(1) : null, arr.size() >= 3 ? (String)arr.get(2) : null, arr.size() >= 4 ? Integer.valueOf(ServiceUtils.hexStringToInt((String)arr.get(3))) : null);
    }

    private void parseDistributedTraceHeaders() {
        HeadersUtil.parseAndAcceptDistributedTraceHeaders(this.tx, this.inboundHeaders);
    }

    public int getSyntheticsVersion() {
        Integer obj = this.synState.getVersion();
        if (obj == null) {
            return -1;
        }
        int version = obj;
        if (version < 0) {
            return -1;
        }
        return version;
    }

    private boolean isSupportedSyntheticsVersion() {
        int version = this.getSyntheticsVersion();
        return version >= 1 && version <= 1;
    }

    public boolean isTrustedSyntheticsRequest() {
        return this.isSupportedSyntheticsVersion() && this.synState.getAccountId() != null;
    }

    public String getSyntheticsResourceId() {
        return this.synState.getSyntheticsResourceId();
    }

    public String getSyntheticsJobId() {
        return this.synState.getSyntheticsJobId();
    }

    public String getSyntheticsMonitorId() {
        return this.synState.getSyntheticsMonitorId();
    }

    public boolean isTrustedCatRequest() {
        return this.catState.getClientCrossProcessId() != null;
    }

    public String getClientCrossProcessId() {
        return this.catState.getClientCrossProcessId();
    }

    public String getReferrerGuid() {
        return this.catState.getReferrerGuid();
    }

    public boolean forceTrace() {
        return this.catState.forceTrace();
    }

    public Integer getReferringPathHash() {
        return this.catState.getReferringPathHash();
    }

    public String getInboundTripId() {
        return this.catState.getInboundTripId();
    }

    public long getRequestContentLength() {
        String contentLengthString;
        long contentLength = -1L;
        String string = contentLengthString = this.inboundHeaders == null ? null : this.inboundHeaders.getHeader(CONTENT_LENGTH_REQUEST_HEADER);
        if (contentLengthString != null) {
            try {
                contentLength = Long.parseLong(contentLengthString);
            }
            catch (NumberFormatException e) {
                Agent.LOG.log(Level.FINER, "Error parsing {0} response header: {1}: {2} in transaction {3}", CONTENT_LENGTH_REQUEST_HEADER, contentLengthString, e, this.tx);
            }
        }
        return contentLength;
    }

    private boolean isClientCrossProcessIdTrusted(String clientCrossProcessId) {
        String accountId = this.getAccountId(clientCrossProcessId);
        if (accountId != null) {
            if (this.tx.getCrossProcessConfig().isTrustedAccountId(accountId)) {
                return true;
            }
            Agent.LOG.log(Level.FINEST, "Account id {0} in client cross process id {1} is not trusted in transaction {2}", accountId, clientCrossProcessId, this.tx);
        } else {
            Agent.LOG.log(Level.FINER, "Account id not found in client cross process id {0} in transaction {1}", clientCrossProcessId, this.tx);
        }
        return false;
    }

    private String getAccountId(String clientCrossProcessId) {
        String accountId = null;
        int index = clientCrossProcessId.indexOf(NEWRELIC_ID_HEADER_SEPARATOR);
        if (index > 0) {
            accountId = clientCrossProcessId.substring(0, index);
        }
        return accountId;
    }

    private JSONArray getJSONArray(String json) {
        JSONArray result = null;
        if (json != null) {
            try {
                JSONParser parser = new JSONParser();
                result = (JSONArray)parser.parse(json);
            }
            catch (Exception ex) {
                Agent.LOG.log(Level.FINER, "Unable to parse header in transaction {0}: {1}", this.tx, ex);
            }
        }
        return result;
    }

    static final class SyntheticsState {
        private final Integer version;
        private final Number accountId;
        private final String syntheticsResourceId;
        private final String syntheticsJobId;
        private final String syntheticsMonitorId;
        static final SyntheticsState NONE = new SyntheticsState(null, null, null, null, null);

        SyntheticsState(Integer version, Number accountId, String syntheticsResourceId, String syntheticsJobId, String syntheticsMonitorId) {
            this.version = version;
            this.accountId = accountId;
            this.syntheticsResourceId = syntheticsResourceId;
            this.syntheticsJobId = syntheticsJobId;
            this.syntheticsMonitorId = syntheticsMonitorId;
        }

        Integer getVersion() {
            return this.version;
        }

        Number getAccountId() {
            return this.accountId;
        }

        String getSyntheticsResourceId() {
            return this.syntheticsResourceId;
        }

        String getSyntheticsJobId() {
            return this.syntheticsJobId;
        }

        String getSyntheticsMonitorId() {
            return this.syntheticsMonitorId;
        }
    }

    static final class CatState {
        private final String clientCrossProcessId;
        private final String referrerGuid;
        private final Boolean forceTrace;
        private final String inboundTripId;
        private final Integer referringPathHash;
        static final CatState NONE = new CatState(null, null, Boolean.FALSE, null, null);

        CatState(String clientCrossProcessId, String referrerGuid, Boolean forceTrace, String inboundTripId, Integer referringPathHash) {
            this.clientCrossProcessId = clientCrossProcessId;
            this.referrerGuid = referrerGuid;
            this.forceTrace = forceTrace;
            this.inboundTripId = inboundTripId;
            this.referringPathHash = referringPathHash;
        }

        String getClientCrossProcessId() {
            return this.clientCrossProcessId;
        }

        String getReferrerGuid() {
            return this.referrerGuid;
        }

        boolean forceTrace() {
            return this.forceTrace;
        }

        String getInboundTripId() {
            return this.inboundTripId;
        }

        Integer getReferringPathHash() {
            return this.referringPathHash;
        }
    }
}

