/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.weavepackage;

import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Queues;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.api.agent.weaver.MatchType;
import com.newrelic.weave.MethodProcessors;
import com.newrelic.weave.utils.BootstrapLoader;
import com.newrelic.weave.utils.ClassCache;
import com.newrelic.weave.utils.ClassInformation;
import com.newrelic.weave.utils.ReferenceUtils;
import com.newrelic.weave.utils.Streams;
import com.newrelic.weave.utils.SynchronizedClassNode;
import com.newrelic.weave.utils.WeaveClassInfo;
import com.newrelic.weave.utils.WeaveUtils;
import com.newrelic.weave.violation.WeaveViolation;
import com.newrelic.weave.weavepackage.PackageValidationResult;
import com.newrelic.weave.weavepackage.Reference;
import com.newrelic.weave.weavepackage.WeavePackageConfig;
import com.newrelic.weave.weavepackage.language.LanguageAdapter;
import com.newrelic.weave.weavepackage.language.LanguageAdapterResult;
import com.newrelic.weave.weavepackage.language.RegisteredLanguageAdapters;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class WeavePackage {
    final Map<String, ClassNode> exactWeaves = Maps.newConcurrentMap();
    final Map<String, ClassNode> baseWeaves = Maps.newConcurrentMap();
    final Map<String, ClassNode> utilClasses = Maps.newConcurrentMap();
    final Map<String, MatchType> weaveMatches = Maps.newConcurrentMap();
    final Map<String, ClassNode> allAnnotationWeaves = Maps.newConcurrentMap();
    final Map<String, ClassNode> baseAnnotationWeaves = Maps.newConcurrentMap();
    final Map<String, Set<String>> requiredAnnotationsLookup = Maps.newConcurrentMap();
    final Map<String, Reference> references = Maps.newConcurrentMap();
    final Set<String> skipIfPresentClasses = Sets.newConcurrentHashSet();
    final Set<String> methodSignatures = Sets.newConcurrentHashSet();
    final Queue<WeaveViolation> packageViolations = Queues.newConcurrentLinkedQueue();
    final Map<String, String> renames = Maps.newConcurrentMap();
    private final WeavePackageConfig config;
    protected volatile boolean weavesBootstrap = false;
    ClassNode errorHandler;
    ClassNode extensionTemplate;

    public static WeavePackage createWeavePackage(JarInputStream jarStream, WeavePackageConfig config) throws Exception {
        ArrayList<byte[]> classBytes = new ArrayList<byte[]>();
        JarEntry entry = null;
        while ((entry = jarStream.getNextJarEntry()) != null) {
            if (!entry.getName().endsWith(".class")) continue;
            classBytes.add(Streams.read(jarStream, false));
        }
        WeavePackage weavePackage = new WeavePackage(config, classBytes);
        return weavePackage;
    }

    public WeavePackage(WeavePackageConfig config, List<byte[]> weavePackageBytes) {
        this.config = config;
        this.processWeaveBytes(weavePackageBytes);
    }

    protected final List<WeaveViolation> processWeaveBytes(List<byte[]> weavePackageBytes) {
        ArrayList<WeaveViolation> violations = new ArrayList<WeaveViolation>();
        for (LanguageAdapter adapter : RegisteredLanguageAdapters.getLanguageAdapters()) {
            try {
                LanguageAdapterResult result = adapter.adapt(weavePackageBytes);
                weavePackageBytes = result.getAdaptedBytes();
                violations.addAll(result.getViolations());
            }
            catch (Throwable result) {}
        }
        block6: for (byte[] weaveClassBytes : weavePackageBytes) {
            boolean isAnnotationMatch;
            ClassNode weaveNode = WeaveUtils.convertToClassNode(weaveClassBytes);
            WeaveClassInfo weave = new WeaveClassInfo(weaveNode);
            violations.addAll(weave.getViolations());
            boolean bl = isAnnotationMatch = !weave.getRequiredAnnotations().isEmpty();
            if (isAnnotationMatch) {
                for (String requiredAnnotation : weave.getRequiredAnnotations()) {
                    if (weave.getMatchType().equals((Object)MatchType.Interface)) {
                        this.baseAnnotationWeaves.put(requiredAnnotation, weaveNode);
                    }
                    this.allAnnotationWeaves.put(requiredAnnotation, weaveNode);
                }
                this.requiredAnnotationsLookup.put(weaveNode.name, weave.getRequiredAnnotations());
                continue;
            }
            if (null == weave.getMatchType()) {
                if (weave.isSkipIfPresent()) {
                    this.skipIfPresentClasses.add(weave.getOriginalName());
                    continue;
                }
                this.utilClasses.put(weaveNode.name, weaveNode);
                continue;
            }
            if (!weaveNode.name.equals(weave.getOriginalName())) {
                this.renames.put(weaveNode.name, weave.getOriginalName());
            }
            this.weaveMatches.put(weave.getOriginalName(), weave.getMatchType());
            switch (weave.getMatchType()) {
                case BaseClass: 
                case Interface: {
                    this.baseWeaves.put(weave.getOriginalName(), weaveNode);
                    continue block6;
                }
            }
            this.exactWeaves.put(weave.getOriginalName(), weaveNode);
        }
        this.preprocessAllWeaveCode();
        this.packageViolations.addAll(violations);
        if (this.isBootstrapClassName(this.exactWeaves.keySet()) || this.isBootstrapClassName(this.baseWeaves.keySet())) {
            this.weavesBootstrap = true;
        }
        return violations;
    }

    public boolean isBootstrapClassName(Collection<String> names) {
        for (String name : names) {
            if (!BootstrapLoader.get().isBootstrapClass(name)) continue;
            return true;
        }
        return false;
    }

    private void preprocessAllWeaveCode() {
        ClassNode node;
        HashSet<String> renamedUtilityClassesToRemove = Sets.newHashSet();
        for (ClassNode classNode : this.utilClasses.values()) {
            String nameBefore = classNode.name;
            ClassNode classNode2 = this.preprocess(classNode);
            this.utilClasses.put(classNode2.name, classNode2);
            if (classNode2.name.equals(nameBefore)) continue;
            renamedUtilityClassesToRemove.add(nameBefore);
        }
        for (Map.Entry entry : this.exactWeaves.entrySet()) {
            node = this.preprocess((ClassNode)entry.getValue());
            entry.setValue(node);
        }
        for (Map.Entry entry : this.baseWeaves.entrySet()) {
            node = this.preprocess((ClassNode)entry.getValue());
            entry.setValue(node);
        }
        for (Map.Entry entry : this.allAnnotationWeaves.entrySet()) {
            node = this.preprocess((ClassNode)entry.getValue());
            entry.setValue(node);
        }
        for (Map.Entry entry : this.baseAnnotationWeaves.entrySet()) {
            node = this.preprocess((ClassNode)entry.getValue());
            entry.setValue(node);
        }
        this.errorHandler = this.preprocess(this.config.getErrorHandleClassNode());
        this.extensionTemplate = this.preprocess(this.config.getExtensionTemplate());
        for (String string : renamedUtilityClassesToRemove) {
            this.utilClasses.remove(string);
        }
        for (ClassNode classNode : this.utilClasses.values()) {
            this.checkReferences(classNode);
        }
        for (Map.Entry entry : this.exactWeaves.entrySet()) {
            this.checkReferences((ClassNode)entry.getValue());
            for (MethodNode methodNode : ((ClassNode)entry.getValue()).methods) {
                this.methodSignatures.add(methodNode.name + methodNode.desc);
            }
        }
        for (Map.Entry entry : this.baseWeaves.entrySet()) {
            this.checkReferences((ClassNode)entry.getValue());
            for (MethodNode methodNode : ((ClassNode)entry.getValue()).methods) {
                this.methodSignatures.add(methodNode.name + methodNode.desc);
            }
        }
    }

    private void checkReferences(ClassNode node) {
        Set<Reference> referencedClasses = Reference.create(node);
        for (Reference reference : referencedClasses) {
            if (reference.className.startsWith("java/") || reference.className.startsWith("javax/") || reference.className.startsWith("com/newrelic/api/") || reference.className.startsWith("com/newrelic/agent/") || this.utilClasses.containsKey(reference.className) || this.exactWeaves.containsKey(reference.className) || this.baseWeaves.containsKey(reference.className)) continue;
            if (this.references.containsKey(reference.className)) {
                Reference otherReference = this.references.get(reference.className);
                otherReference.merge(reference);
                continue;
            }
            this.references.put(reference.className, reference);
        }
    }

    private ClassNode preprocess(ClassNode input) {
        SynchronizedClassNode result = new SynchronizedClassNode(327680);
        ClassVisitor preprocessChain = this.config.getPreprocessor().preprocess(result, this.utilClasses.keySet(), this);
        preprocessChain = MethodProcessors.fixInvocationInstructions(preprocessChain, this.weaveMatches);
        preprocessChain = MethodProcessors.replaceGetImplementationTitle(preprocessChain, this.getName());
        if (this.renames.size() > 0) {
            preprocessChain = ReferenceUtils.getRenamingVisitor(this.renames, preprocessChain);
        }
        input.accept(preprocessChain);
        return result;
    }

    public boolean hasMatcher(String className, String[] superNames, String[] interfaceNames, Set<String> classAnnotations, ClassCache classCache) throws IOException {
        int i;
        if (this.exactWeaves.containsKey(className) || this.baseWeaves.containsKey(className)) {
            return true;
        }
        for (i = 0; i < superNames.length; ++i) {
            if (!this.baseWeaves.containsKey(superNames[i])) continue;
            return true;
        }
        for (i = 0; i < interfaceNames.length; ++i) {
            if (!this.baseWeaves.containsKey(interfaceNames[i])) continue;
            return true;
        }
        Sets.SetView<String> matchingAnnotations = Sets.intersection(this.allAnnotationWeaves.keySet(), classAnnotations);
        if (!matchingAnnotations.isEmpty()) {
            return true;
        }
        if (!this.baseAnnotationWeaves.isEmpty()) {
            Set<String> requiredBaseAnnotations = this.baseAnnotationWeaves.keySet();
            for (String interfaceName : interfaceNames) {
                ClassInformation classInformation = classCache.getClassInformation(interfaceName);
                if (!this.classHasRequiredAnnotations(classInformation, requiredBaseAnnotations)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean classHasRequiredAnnotations(ClassInformation classInformation, Set<String> requiredAnnotations) {
        return classInformation != null && !Sets.intersection(classInformation.classAnnotationNames, requiredAnnotations).isEmpty();
    }

    public List<WeaveViolation> getPackageViolations() {
        return Lists.newArrayList(this.packageViolations);
    }

    public PackageValidationResult validate(ClassCache cache) throws IOException {
        if (this.packageViolations.size() == 0) {
            return new PackageValidationResult(this, cache, this.references.values(), this.exactWeaves, this.baseWeaves, this.allAnnotationWeaves, this.baseAnnotationWeaves, this.utilClasses, this.skipIfPresentClasses, this.errorHandler, this.extensionTemplate);
        }
        return new PackageValidationResult(this, this.packageViolations);
    }

    public WeavePackageConfig getConfig() {
        return this.config;
    }

    public String getName() {
        return this.config.getName();
    }

    public float getVersion() {
        return this.config.getVersion();
    }

    public Map<String, MatchType> getMatchTypes() {
        return this.weaveMatches;
    }

    public Set<String> getReferencedClassNames() {
        return this.references.keySet();
    }

    public Set<String> getAllRequiredAnnotationClasses() {
        return this.allAnnotationWeaves.keySet();
    }

    public Set<String> getRequiredAnnotationClassesForAnnotationWeave(String annotationWeaveClassName) {
        Set<String> requiredAnnotations = this.requiredAnnotationsLookup.get(annotationWeaveClassName);
        return requiredAnnotations != null ? requiredAnnotations : Collections.emptySet();
    }

    public Set<String> getRequiredClasses() {
        HashSet<String> required = Sets.newHashSet();
        required.addAll(this.exactWeaves.keySet());
        required.addAll(this.baseWeaves.keySet());
        required.addAll(this.references.keySet());
        required.addAll(this.allAnnotationWeaves.keySet());
        return required;
    }

    public Set<String> getIllegalClasses() {
        return this.skipIfPresentClasses;
    }

    public boolean weavesBootstrap() {
        return this.weavesBootstrap;
    }

    public Set<String> getMethodSignatures() {
        return this.methodSignatures;
    }

    public String toString() {
        return "WeavePackage [config=" + this.config + "]";
    }
}

