/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.utils;

import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.FieldVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AnnotationNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.weave.utils.ClassInformationFinder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ClassInformation {
    public String className;
    public String superName;
    public final Set<String> interfaceNames = Sets.newHashSet();
    public final Set<MemberInformation> fields = Sets.newHashSet();
    public final Set<MemberInformation> methods = Sets.newHashSet();
    public final Set<AnnotationNode> classAnnotationNodes = Sets.newHashSet();
    public final Set<String> classAnnotationNames = Sets.newHashSet();

    public static ClassInformation fromClassBytes(byte[] classBytes) {
        if (classBytes == null) {
            return null;
        }
        ClassInformationExtractor extractor = new ClassInformationExtractor();
        new ClassReader(classBytes).accept(extractor, 7);
        return extractor.result;
    }

    public static ClassInformation fromClassNode(ClassNode classNode) {
        if (classNode == null) {
            return null;
        }
        ClassInformationExtractor extractor = new ClassInformationExtractor();
        classNode.accept(extractor);
        return extractor.result;
    }

    public Set<MemberInformation> getAllFields(ClassInformationFinder finder) throws IOException {
        ClassInformation info;
        HashSet<MemberInformation> result = Sets.newHashSet(this.fields);
        if (this.superName != null && null != (info = finder.getClassInformation(this.superName))) {
            result.addAll(info.getAllFields(finder));
        }
        for (String interfaceName : this.interfaceNames) {
            ClassInformation info2 = finder.getClassInformation(interfaceName);
            if (null == info2) continue;
            result.addAll(info2.getAllFields(finder));
        }
        return result;
    }

    public Set<MemberInformation> getAllMethods(ClassInformationFinder finder) throws IOException {
        ClassInformation info;
        HashSet<MemberInformation> result = Sets.newHashSet(this.methods);
        if (this.superName != null && null != (info = finder.getClassInformation(this.superName))) {
            result.addAll(info.getAllMethods(finder));
        }
        for (String interfaceName : this.interfaceNames) {
            ClassInformation info2 = finder.getClassInformation(interfaceName);
            if (null == info2) continue;
            result.addAll(info2.getAllMethods(finder));
        }
        return result;
    }

    public Set<String> getAllInterfaces(ClassInformationFinder finder) throws IOException {
        ClassInformation info;
        HashSet<String> result = Sets.newHashSet(this.interfaceNames);
        if (this.superName != null && null != (info = finder.getClassInformation(this.superName))) {
            result.addAll(info.getAllInterfaces(finder));
        }
        for (String interfaceName : this.interfaceNames) {
            ClassInformation info2 = finder.getClassInformation(interfaceName);
            if (null == info2) continue;
            result.addAll(info2.getAllInterfaces(finder));
        }
        return result;
    }

    public List<String> getAllSuperNames(ClassInformationFinder finder) throws IOException {
        LinkedList<String> result = new LinkedList<String>();
        String currentSuper = this.superName;
        while (currentSuper != null) {
            result.add(currentSuper);
            ClassInformation info = finder.getClassInformation(currentSuper);
            if (null == info) break;
            currentSuper = info.superName;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassInformation that = (ClassInformation)o;
        if (!this.className.equals(that.className)) {
            return false;
        }
        if (this.superName != null ? !this.superName.equals(that.superName) : that.superName != null) {
            return false;
        }
        if (!this.interfaceNames.equals(that.interfaceNames)) {
            return false;
        }
        if (!this.fields.equals(that.fields)) {
            return false;
        }
        return this.methods.equals(that.methods);
    }

    public int hashCode() {
        int result = this.className.hashCode();
        result = 31 * result + (this.superName != null ? this.superName.hashCode() : 0);
        result = 31 * result + this.interfaceNames.hashCode();
        result = 31 * result + this.fields.hashCode();
        result = 31 * result + this.methods.hashCode();
        return result;
    }

    public static class MemberInformation {
        public final String name;
        public final String desc;
        public final int access;
        public final Set<AnnotationNode> annotations;

        public MemberInformation(String name, String desc, int access) {
            this.name = name;
            this.desc = desc;
            this.access = access;
            this.annotations = Sets.newHashSet();
        }

        public MemberInformation(String name, String desc, int access, Set<AnnotationNode> annotations) {
            this.name = name;
            this.desc = desc;
            this.access = access;
            this.annotations = annotations;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemberInformation method = (MemberInformation)o;
            if (this.access != method.access) {
                return false;
            }
            if (!this.name.equals(method.name)) {
                return false;
            }
            return this.desc.equals(method.desc);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.desc.hashCode();
            result = 31 * result + this.access;
            return result;
        }
    }

    static class CollectAnnotationsVisitor
    extends AnnotationVisitor {
        final List<Object> values = new ArrayList<Object>();
        AnnotationNode result;

        public CollectAnnotationsVisitor(int api) {
            super(api);
        }

        @Override
        public void visit(String name, Object value) {
            this.values.add(name);
            this.values.add(value);
            super.visit(name, value);
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            this.values.add(name);
            this.values.add(value);
            super.visitEnum(name, desc, value);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, final String desc) {
            final CollectAnnotationsVisitor collectAnnotationsVisitor = new CollectAnnotationsVisitor(this.api);
            return new AnnotationVisitor(this.api, collectAnnotationsVisitor){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    AnnotationNode annotationNode = collectAnnotationsVisitor.getAnnotationNode();
                    if (annotationNode != null) {
                        annotationNode.desc = desc;
                        CollectAnnotationsVisitor.this.values.add(annotationNode);
                    }
                }
            };
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            this.values.add(name);
            final CollectAnnotationsVisitor collectAnnotationsVisitor = new CollectAnnotationsVisitor(this.api);
            return new AnnotationVisitor(this.api){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    AnnotationNode annotationNode = collectAnnotationsVisitor.getAnnotationNode();
                    if (annotationNode != null) {
                        CollectAnnotationsVisitor.this.values.add(annotationNode);
                    }
                }
            };
        }

        @Override
        public void visitEnd() {
            this.result = new AnnotationNode("");
            this.result.values = this.values;
            super.visitEnd();
        }

        public AnnotationNode getAnnotationNode() {
            return this.result;
        }
    }

    private static final class ClassInformationExtractor
    extends ClassVisitor {
        final ClassInformation result = new ClassInformation();

        public ClassInformationExtractor() {
            super(327680);
        }

        @Override
        public AnnotationVisitor visitAnnotation(final String desc, boolean visible) {
            final CollectAnnotationsVisitor collectAnnotationsVisitor = new CollectAnnotationsVisitor(this.api);
            return new AnnotationVisitor(this.api, collectAnnotationsVisitor){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    AnnotationNode annotationNode = collectAnnotationsVisitor.getAnnotationNode();
                    if (annotationNode != null) {
                        annotationNode.desc = desc;
                        ClassInformationExtractor.this.result.classAnnotationNodes.add(annotationNode);
                        ClassInformationExtractor.this.result.classAnnotationNames.add(Type.getType(annotationNode.desc).getClassName());
                    }
                }
            };
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.result.className = name;
            if (null != superName) {
                this.result.superName = superName;
            }
            if (null != interfaces) {
                Collections.addAll(this.result.interfaceNames, interfaces);
            }
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            this.result.fields.add(new MemberInformation(name, desc, access));
            return null;
        }

        @Override
        public MethodVisitor visitMethod(final int access, final String name, final String desc, String signature, String[] exceptions) {
            MethodVisitor methodVisitor = super.visitMethod(access, desc, name, signature, exceptions);
            return new MethodVisitor(this.api, methodVisitor){
                final Set<AnnotationNode> annotations;
                {
                    super(x0, x1);
                    this.annotations = Sets.newHashSet();
                }

                @Override
                public AnnotationVisitor visitAnnotation(final String desc2, boolean visible) {
                    final CollectAnnotationsVisitor collectAnnotationsVisitor = new CollectAnnotationsVisitor(this.api);
                    return new AnnotationVisitor(this.api, collectAnnotationsVisitor){

                        @Override
                        public void visitEnd() {
                            super.visitEnd();
                            AnnotationNode annotationNode = collectAnnotationsVisitor.getAnnotationNode();
                            if (annotationNode != null) {
                                annotationNode.desc = desc2;
                                annotations.add(annotationNode);
                            }
                        }
                    };
                }

                @Override
                public void visitEnd() {
                    ClassInformationExtractor.this.result.methods.add(new MemberInformation(name, desc, access, this.annotations));
                }
            };
        }
    }
}

