/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.utilization;

import com.newrelic.agent.Agent;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsWorks;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DockerData {
    private static final String FILE_WITH_CONTAIER_ID = "/proc/self/cgroup";
    private static final String CPU = "cpu";
    private static final Pattern DOCKER_NATVIE_DRIVER_WOUT_SYSTEMD = Pattern.compile("^/docker/([0-9a-f]+)$");
    private static final Pattern DOCKER_NATIVE_DRIVER_W_SYSTEMD = Pattern.compile("^/system\\.slice/docker-([0-9a-f]+)\\.scope$");
    private static final Pattern DOCKER_LXC_DRVIER = Pattern.compile("^/lxc/([0-9a-f]+)$");

    public static String getDockerContainerId(boolean isLinux) {
        if (isLinux) {
            File cpuInfoFile = new File(FILE_WITH_CONTAIER_ID);
            return DockerData.getDockerIdFromFile(cpuInfoFile);
        }
        return null;
    }

    protected static String getDockerIdFromFile(File cpuInfoFile) {
        if (cpuInfoFile.exists() && cpuInfoFile.canRead()) {
            try {
                FileReader fileReader = new FileReader(cpuInfoFile);
                return DockerData.readFile(fileReader);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String readFile(Reader reader) {
        BufferedReader bReader = null;
        try {
            String line;
            bReader = new BufferedReader(reader);
            StringBuilder resultGoesHere = new StringBuilder();
            while ((line = bReader.readLine()) != null) {
                if (!DockerData.checkLineAndGetResult(line, resultGoesHere)) continue;
                String value = resultGoesHere.toString().trim();
                if (DockerData.isInvalidDockerValue(value)) {
                    Agent.LOG.log(Level.WARNING, MessageFormat.format("Failed to validate Docker value {0}", value));
                    DockerData.recordDockerError();
                    String string = null;
                    return string;
                }
                String string = value;
                return string;
            }
        }
        catch (Throwable e) {
            Agent.LOG.log(Level.FINEST, e, "Exception occured when reading docker file.", new Object[0]);
            DockerData.recordDockerError();
        }
        finally {
            if (bReader != null) {
                try {
                    bReader.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    protected static boolean isInvalidDockerValue(String value) {
        if (value == null) {
            return true;
        }
        if (value.length() != 64) {
            return true;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') continue;
            return true;
        }
        return false;
    }

    protected static void recordDockerError() {
        ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork("Supportability/utilization/docker/error", 1));
    }

    protected static boolean checkLineAndGetResult(String line, StringBuilder resultGoesHere) {
        String[] parts = line.split(":");
        if (parts.length == 3 && DockerData.validCpuLine(parts[1])) {
            String mayContainId = parts[2];
            if (DockerData.checkAndGetMatch(DOCKER_NATVIE_DRIVER_WOUT_SYSTEMD, resultGoesHere, mayContainId)) {
                return true;
            }
            if (DockerData.checkAndGetMatch(DOCKER_NATIVE_DRIVER_W_SYSTEMD, resultGoesHere, mayContainId)) {
                return true;
            }
            if (DockerData.checkAndGetMatch(DOCKER_LXC_DRVIER, resultGoesHere, mayContainId)) {
                return true;
            }
            if (!mayContainId.equals("/")) {
                Agent.LOG.log(Level.FINE, "Docker Data: Ignoring unrecognized cgroup ID format: {0}", new Object[]{mayContainId});
            }
        }
        return false;
    }

    private static boolean validCpuLine(String segment) {
        if (segment != null) {
            String[] parts;
            for (String current : parts = segment.split(",")) {
                if (!current.equals(CPU)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkAndGetMatch(Pattern p, StringBuilder result, String segment) {
        Matcher m = p.matcher(segment);
        if (m.matches() && m.groupCount() == 1) {
            result.append(m.group(1));
            return true;
        }
        return false;
    }
}

