/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.TransactionErrorPriority;
import com.newrelic.agent.dispatchers.Dispatcher;
import com.newrelic.agent.dispatchers.OtherDispatcher;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.TracerFlags;
import com.newrelic.agent.tracers.TransactionActivityInitiator;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;

public class OtherRootTracer
extends DefaultTracer
implements TransactionActivityInitiator {
    private final MetricNameFormat uri;

    public OtherRootTracer(Transaction transaction, ClassMethodSignature sig, Object object, MetricNameFormat uri) {
        this(transaction.getTransactionActivity(), sig, object, uri);
    }

    public OtherRootTracer(TransactionActivity txa, ClassMethodSignature sig, Object target, MetricNameFormat uri) {
        this(txa, sig, target, uri, 6, System.nanoTime());
    }

    public OtherRootTracer(TransactionActivity txa, ClassMethodSignature sig, Object target, MetricNameFormat uri, int flags, long pStartTime) {
        super(txa, sig, target, new ClassMethodMetricNameFormat(sig, target), TracerFlags.forceMandatoryRootFlags((int)flags), pStartTime);
        this.uri = uri;
    }

    @Override
    public Dispatcher createDispatcher() {
        return new OtherDispatcher(this.getTransaction(), this.uri);
    }

    @Override
    protected void doFinish(Throwable throwable) {
        super.doFinish(throwable);
        if (this.equals(this.getTransaction().getTransactionActivity().getRootTracer())) {
            this.getTransaction().setThrowable(throwable, TransactionErrorPriority.TRACER, false);
        }
    }
}

