/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.TransactionErrorPriority;
import com.newrelic.agent.dispatchers.Dispatcher;
import com.newrelic.agent.dispatchers.OtherDispatcher;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultSqlTracer;
import com.newrelic.agent.tracers.TransactionActivityInitiator;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;

public class OtherRootSqlTracer
extends DefaultSqlTracer
implements TransactionActivityInitiator {
    private final MetricNameFormat uri;

    public OtherRootSqlTracer(Transaction transaction, ClassMethodSignature sig, Object object, MetricNameFormat metricNameFormatter) {
        this(transaction.getTransactionActivity(), sig, object, metricNameFormatter);
    }

    public OtherRootSqlTracer(Transaction transaction, ClassMethodSignature sig, Object object, MetricNameFormat metricNameFormatter, int tracerFlags, long time) {
        super(transaction, sig, object, metricNameFormatter, tracerFlags, time);
        this.uri = metricNameFormatter;
    }

    public OtherRootSqlTracer(TransactionActivity txa, ClassMethodSignature sig, Object object, MetricNameFormat metricNameFormatter) {
        super(txa, sig, object, metricNameFormatter, 6);
        this.uri = metricNameFormatter;
    }

    @Override
    public Dispatcher createDispatcher() {
        return new OtherDispatcher(this.getTransaction(), this.uri);
    }

    @Override
    protected void doFinish(Throwable throwable) {
        super.doFinish(throwable);
        Transaction transaction = this.getTransaction();
        if (transaction != null && this.equals(transaction.getTransactionActivity().getRootTracer())) {
            transaction.setThrowable(throwable, TransactionErrorPriority.TRACER, false);
        }
    }
}

