/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionListener;
import com.newrelic.agent.attributes.AttributesUtils;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigListener;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import com.newrelic.agent.deps.com.google.common.cache.CacheLoader;
import com.newrelic.agent.deps.com.google.common.cache.LoadingCache;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.Service;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.FixedSizeArrayList;
import com.newrelic.agent.service.analytics.ReservoirSampledArrayList;
import com.newrelic.agent.service.analytics.TransactionEvent;
import com.newrelic.agent.service.analytics.TransactionEventsConfigUtils;
import com.newrelic.agent.stats.AbstractStats;
import com.newrelic.agent.stats.CountStats;
import com.newrelic.agent.stats.StatsBase;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.transaction.PriorityTransactionName;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class TransactionEventsService
extends AbstractService
implements Service,
HarvestListener,
TransactionListener,
AgentConfigListener {
    private final boolean enabled;
    private final int maxSamplesStored;
    private final ConcurrentHashMap<String, ReservoirSampledArrayList<TransactionEvent>> reservoirForApp = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, FixedSizeArrayList<TransactionEvent>> syntheticsListForApp = new ConcurrentHashMap();
    private final ConcurrentMap<String, Boolean> isEnabledForApp = new ConcurrentHashMap<String, Boolean>();
    final ArrayDeque<FixedSizeArrayList<TransactionEvent>> pendingSyntheticsArrays = new ArrayDeque();
    static final int MAX_UNSENT_SYNTHETICS_HOLDERS = 25;
    static final int MAX_SYNTHETIC_EVENTS_PER_APP = 200;
    private final LoadingCache<String, String> transactionNameCache;

    public TransactionEventsService() {
        super(TransactionEventsService.class.getSimpleName());
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.maxSamplesStored = TransactionEventsConfigUtils.getMaxSamplesStored(config);
        this.enabled = TransactionEventsConfigUtils.isTransactionEventsEnabled(config, this.maxSamplesStored);
        this.isEnabledForApp.put(config.getApplicationName(), this.enabled);
        this.transactionNameCache = CacheBuilder.newBuilder().maximumSize(this.maxSamplesStored).expireAfterAccess(5L, TimeUnit.MINUTES).build(new CacheLoader<String, String>(){

            @Override
            public String load(String key) throws Exception {
                return key;
            }
        });
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.enabled) {
            ServiceFactory.getHarvestService().addHarvestListener(this);
            ServiceFactory.getTransactionService().addTransactionListener(this);
            ServiceFactory.getConfigService().addIAgentConfigListener(this);
        }
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getHarvestService().removeHarvestListener(this);
        ServiceFactory.getTransactionService().removeTransactionListener(this);
        ServiceFactory.getConfigService().removeIAgentConfigListener(this);
        this.reservoirForApp.clear();
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
        this.beforeHarvestSynthetics(appName, statsEngine);
        ReservoirSampledArrayList reservoirToSend = this.reservoirForApp.put(appName, new ReservoirSampledArrayList(this.maxSamplesStored));
        if (reservoirToSend != null && reservoirToSend.size() > 0) {
            try {
                ServiceFactory.getRPMService(appName).sendAnalyticsEvents(this.maxSamplesStored, reservoirToSend.getNumberOfTries(), Collections.unmodifiableList(reservoirToSend));
            }
            catch (Exception e) {
                Agent.LOG.fine("Unable to send events for regular transactions. This operation will be retried.");
                ReservoirSampledArrayList<TransactionEvent> currentReservoir = this.reservoirForApp.get(appName);
                currentReservoir.addAll(reservoirToSend);
            }
        }
    }

    private void beforeHarvestSynthetics(String appName, StatsEngine statsEngine) {
        FixedSizeArrayList<TransactionEvent> toSend;
        FixedSizeArrayList current = this.syntheticsListForApp.put(appName, new FixedSizeArrayList(200));
        if (current != null && current.size() > 0) {
            if (this.pendingSyntheticsArrays.size() < 25) {
                this.pendingSyntheticsArrays.add(current);
            } else {
                Agent.LOG.fine("Some synthetic transaction events were discarded.");
            }
        }
        int maxToSend = 5;
        for (int nSent = 0; nSent < 5 && (toSend = this.pendingSyntheticsArrays.poll()) != null; ++nSent) {
            try {
                ServiceFactory.getRPMService(appName).sendAnalyticsEvents(200, toSend.size(), Collections.unmodifiableList(toSend));
                ++nSent;
                continue;
            }
            catch (Exception e) {
                Agent.LOG.fine("Unable to send events for synthetic transactions. This operation will be retried.");
                this.pendingSyntheticsArrays.add(toSend);
                break;
            }
        }
    }

    @Override
    public void afterHarvest(String appName) {
    }

    private boolean getIsEnabledForApp(AgentConfig config, String currentAppName) {
        Boolean appEnabled = (Boolean)this.isEnabledForApp.get(currentAppName);
        if (appEnabled == null) {
            appEnabled = TransactionEventsConfigUtils.isTransactionEventsEnabled(config, TransactionEventsConfigUtils.getMaxSamplesStored(config));
            this.isEnabledForApp.put(currentAppName, appEnabled);
        }
        return appEnabled;
    }

    @Override
    public void dispatcherTransactionFinished(TransactionData transactionData, TransactionStats transactionStats) {
        String name = transactionData.getApplicationName();
        if (!this.getIsEnabledForApp(transactionData.getAgentConfig(), name)) {
            this.reservoirForApp.remove(name);
            return;
        }
        boolean persisted = false;
        if (transactionData.isSyntheticTransaction()) {
            FixedSizeArrayList<TransactionEvent> currentSyntheticsList = this.syntheticsListForApp.get(name);
            while (currentSyntheticsList == null) {
                this.syntheticsListForApp.putIfAbsent(name, new FixedSizeArrayList(200));
                currentSyntheticsList = this.syntheticsListForApp.get(name);
            }
            persisted = currentSyntheticsList.add(TransactionEventsService.createEvent(transactionData, transactionStats, this.getMetricName(transactionData)));
            String msg = MessageFormat.format("Added Synthetics transaction event: {0}", transactionData);
            Agent.LOG.finest(msg);
        }
        if (!persisted) {
            ReservoirSampledArrayList<TransactionEvent> currentReservoir = this.reservoirForApp.get(name);
            while (currentReservoir == null) {
                this.reservoirForApp.putIfAbsent(name, new ReservoirSampledArrayList(this.maxSamplesStored));
                currentReservoir = this.reservoirForApp.get(name);
            }
            Integer slot = currentReservoir.getSlot();
            if (slot != null) {
                currentReservoir.set(slot, TransactionEventsService.createEvent(transactionData, transactionStats, this.getMetricName(transactionData)));
            }
        }
    }

    private String getMetricName(TransactionData transactionData) {
        String metricName = transactionData.getBlameOrRootMetricName();
        try {
            metricName = this.transactionNameCache.get(metricName);
        }
        catch (ExecutionException e) {
            Agent.LOG.finest("Error fetching cached transaction name: " + e.toString());
        }
        return metricName;
    }

    public static TransactionEvent createEvent(TransactionData transactionData, TransactionStats transactionStats, String metricName) {
        PriorityTransactionName transactionName;
        String otherCategory;
        long startTime = transactionData.getWallClockStartTimeMs();
        long durationInNanos = transactionData.getLegacyDuration();
        Integer port = ServiceFactory.getEnvironmentService().getEnvironment().getAgentIdentity().getServerPort();
        String subType = "Web";
        if (!transactionData.isWebTransaction() && (otherCategory = (transactionName = transactionData.getPriorityTransactionName()).getCategory()) != null) {
            subType = otherCategory;
        }
        TransactionEvent event = new TransactionEvent(transactionData.getApplicationName(), subType, startTime, metricName, (float)durationInNanos / 1.0E9f, transactionData.getGuid(), transactionData.getReferrerGuid(), port, transactionData.getTripId(), transactionData.getReferringPathHash(), transactionData.getAlternatePathHashes(), transactionData.getApdexPerfZone(), transactionData.getSyntheticsResourceId(), transactionData.getSyntheticsMonitorId(), transactionData.getSyntheticsJobId(), transactionData.hasReportableErrorThatIsNotIgnored(), (float)transactionData.getTransactionTime().getTotalSumTimeInNanos() / 1.0E9f, transactionData.getTransaction().getTimeoutCause());
        if (transactionData.getTransactionTime().getTimeToFirstByteInNanos() > 0L) {
            event.timeToFirstByte = (float)transactionData.getTransactionTime().getTimeToFirstByteInNanos() / 1.0E9f;
        }
        if (transactionData.getTransactionTime().getTimetoLastByteInNanos() > 0L) {
            event.timeToLastByte = (float)transactionData.getTransactionTime().getTimetoLastByteInNanos() / 1.0E9f;
        }
        if (transactionData.getTripId() != null) {
            event.pathHash = transactionData.generatePathHash();
        }
        event.queueDuration = TransactionEventsService.retrieveMetricIfExists(transactionStats, "WebFrontend/QueueTime").getTotal();
        event.externalDuration = TransactionEventsService.retrieveMetricIfExists(transactionStats, "External/all").getTotal();
        event.externalCallCount = TransactionEventsService.retrieveMetricIfExists(transactionStats, "External/all").getCallCount();
        event.databaseDuration = TransactionEventsService.retrieveMetricIfExists(transactionStats, "Datastore/all").getTotal();
        event.databaseCallCount = TransactionEventsService.retrieveMetricIfExists(transactionStats, "Datastore/all").getCallCount();
        event.gcCumulative = TransactionEventsService.retrieveMetricIfExists(transactionStats, "GC/cumulative").getTotal();
        if (ServiceFactory.getAttributesService().isAttributesEnabledForEvents(transactionData.getApplicationName())) {
            event.userAttributes = transactionData.getUserAttributes();
            event.agentAttributes = transactionData.getAgentAttributes();
            event.agentAttributes.putAll(AttributesUtils.appendAttributePrefixes(transactionData.getPrefixedAttributes()));
        }
        return event;
    }

    private static CountStats retrieveMetricIfExists(TransactionStats transactionStats, String metricName) {
        if (!transactionStats.getUnscopedStats().getStatsMap().containsKey(metricName)) {
            return NoCallCountStats.NO_STATS;
        }
        return transactionStats.getUnscopedStats().getResponseTimeStats(metricName);
    }

    @Override
    public void configChanged(String appName, AgentConfig agentConfig) {
        this.isEnabledForApp.remove(appName);
    }

    public ReservoirSampledArrayList<TransactionEvent> unsafeGetEventData(String appName) {
        return this.reservoirForApp.get(appName);
    }

    private static class NoCallCountStats
    extends AbstractStats {
        static final NoCallCountStats NO_STATS = new NoCallCountStats();

        private NoCallCountStats() {
        }

        @Override
        public float getTotal() {
            return Float.NEGATIVE_INFINITY;
        }

        @Override
        public float getTotalExclusiveTime() {
            return Float.NEGATIVE_INFINITY;
        }

        @Override
        public float getMinCallTime() {
            return Float.NEGATIVE_INFINITY;
        }

        @Override
        public float getMaxCallTime() {
            return Float.NEGATIVE_INFINITY;
        }

        @Override
        public double getSumOfSquares() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public boolean hasData() {
            return false;
        }

        @Override
        public void reset() {
        }

        @Override
        public void merge(StatsBase stats) {
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return NO_STATS;
        }
    }
}

