/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile.v2;

import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.profile.v2.IProfile;
import com.newrelic.agent.profile.v2.ProfileSegment;
import com.newrelic.agent.profile.v2.ProfiledMethod;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public abstract class BaseTree<S extends ProfileSegment>
implements JSONStreamAware {
    private final ConcurrentMap<ProfiledMethod, S> rootSegments;
    protected final IProfile profile;

    protected BaseTree(IProfile profile) {
        this.profile = profile;
        this.rootSegments = Maps.newConcurrentMap();
    }

    protected final S add(ProfiledMethod method, S parent, boolean runnable) {
        S result = this.add(method, parent);
        ((ProfileSegment)result).incrementCallCount(runnable);
        return result;
    }

    private S add(ProfiledMethod method, S parent) {
        Object result;
        if (parent == null) {
            ProfileSegment previousValue;
            result = (ProfileSegment)this.rootSegments.get(method);
            if (result == null && null != (previousValue = (ProfileSegment)this.rootSegments.putIfAbsent(method, result = this.createProfiledMethod(method)))) {
                return (S)previousValue;
            }
        } else {
            result = ((ProfileSegment)parent).addChild(method);
        }
        return (S)result;
    }

    protected abstract S createProfiledMethod(ProfiledMethod var1);

    public final int getCallSiteCount() {
        int count = 0;
        for (ProfileSegment segment : this.rootSegments.values()) {
            count += segment.getCallSiteCount();
        }
        return count;
    }

    public final S getSegment(ProfiledMethod profiledMethod) {
        return (S)((ProfileSegment)this.rootSegments.get(profiledMethod));
    }

    public final Collection<S> getRootSegments() {
        return this.rootSegments.values();
    }

    public final int getRootCount() {
        return this.getRootSegments().size();
    }

    public final int getMethodCount() {
        HashSet<ProfiledMethod> methodNames = new HashSet<ProfiledMethod>();
        for (ProfileSegment segment : this.rootSegments.values()) {
            methodNames.addAll(segment.getMethods());
        }
        return methodNames.size();
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        Collection<S> rootSegments = this.getRootSegments();
        ArrayList<Map<String, Object>> list = Lists.newArrayListWithCapacity(rootSegments.size() + 1);
        list.add(this.getExtraData());
        list.addAll(rootSegments);
        JSONArray.writeJSONString(list, out);
    }

    protected abstract Map<String, Object> getExtraData();
}

