/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.jmx.create;

import com.newrelic.agent.Agent;
import com.newrelic.agent.extension.Extension;
import com.newrelic.agent.jmx.JmxType;
import com.newrelic.agent.jmx.create.JmxAttributeFilter;
import com.newrelic.agent.jmx.create.JmxMetricModifier;
import com.newrelic.agent.jmx.create.JmxObject;
import com.newrelic.agent.jmx.metrics.JmxMetric;
import com.newrelic.agent.stats.StatsEngine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public abstract class JmxGet
extends JmxObject {
    private static final Pattern TYPE_QUERY_PATTERN = Pattern.compile(",(.*?)=");
    private static final Pattern PULL_VALUE_PATTERN = Pattern.compile("\\{(.*?)\\}");
    private static final Pattern PULL_ATTRIBUTE_PATTERN = Pattern.compile("\\:(.*?)\\:");
    private final String rootMetricName;
    private final boolean isPattern;
    private final Set<String> attributes;
    private final List<JmxMetric> metrics;
    private final Extension origin;
    private final JmxAttributeFilter attributeFilter;
    private final JmxMetricModifier modifier;

    public JmxGet(String pObjectName, String rootMetricName, String safeName, Map<JmxType, List<String>> pAttributesToType, Extension origin) throws MalformedObjectNameException {
        super(pObjectName, safeName);
        this.origin = origin;
        this.attributeFilter = null;
        this.modifier = null;
        this.rootMetricName = this.getRootMetricName(rootMetricName);
        this.isPattern = JmxGet.isPattern(rootMetricName);
        this.attributes = new HashSet<String>();
        this.metrics = new ArrayList<JmxMetric>();
        for (Map.Entry<JmxType, List<String>> current : pAttributesToType.entrySet()) {
            JmxType type = current.getKey();
            List<String> attrs = current.getValue();
            for (String att : attrs) {
                this.attributes.add(att);
                this.metrics.add(JmxMetric.create(att, type));
            }
        }
    }

    public JmxGet(String pObjectName, String safeName, String pRootMetric, List<JmxMetric> pMetrics, JmxAttributeFilter attributeFilter, JmxMetricModifier pModifier) throws MalformedObjectNameException {
        super(pObjectName, safeName);
        this.origin = null;
        this.attributeFilter = attributeFilter;
        this.modifier = pModifier;
        this.rootMetricName = this.getRootMetricName(pRootMetric);
        this.isPattern = JmxGet.isPattern(this.rootMetricName);
        this.metrics = pMetrics == null ? new ArrayList<JmxMetric>() : pMetrics;
        this.attributes = new HashSet<String>();
        for (JmxMetric m : this.metrics) {
            this.attributes.addAll(Arrays.asList(m.getAttributes()));
        }
    }

    public abstract void recordStats(StatsEngine var1, Map<ObjectName, Map<String, Float>> var2, MBeanServer var3);

    private static boolean isPattern(String rootMetricName) {
        if (rootMetricName != null) {
            return rootMetricName.contains("{");
        }
        return false;
    }

    private String getRootMetricName(String root) {
        if (root != null) {
            if (!root.endsWith("/")) {
                root = root + "/";
            }
            if (!root.startsWith("JMX/") && !root.startsWith("JmxBuiltIn")) {
                root = "JMX/" + root;
            }
        }
        return root;
    }

    public Collection<String> getAttributes() {
        return this.attributes;
    }

    public String getRootMetricName(ObjectName actualName, MBeanServer server) {
        if (this.rootMetricName != null) {
            return this.pullAttValuesFromName(actualName, server);
        }
        return this.getDefaultName(actualName);
    }

    private String pullAttValuesFromName(ObjectName actualName, MBeanServer server) {
        if (!this.isPattern) {
            return this.rootMetricName;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = PULL_VALUE_PATTERN.matcher(this.rootMetricName);
        Hashtable<String, String> keyProperties = actualName.getKeyPropertyList();
        String value = null;
        while (m.find()) {
            String key = m.group(1);
            Matcher attributeMatcher = PULL_ATTRIBUTE_PATTERN.matcher(key);
            if (attributeMatcher.matches()) {
                key = attributeMatcher.group(1);
                try {
                    value = server.getAttribute(actualName, key).toString();
                }
                catch (Throwable e) {
                    Agent.LOG.log(Level.FINEST, e, e.getMessage(), new Object[0]);
                }
            } else {
                value = (String)keyProperties.get(key);
            }
            if (value != null) {
                m.appendReplacement(sb, JmxGet.cleanValue(value));
                continue;
            }
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        if (this.modifier == null) {
            return sb.toString();
        }
        return this.modifier.getMetricName(sb.toString());
    }

    protected static String cleanValue(String value) {
        if ((value = value.trim()).length() > 0 && value.charAt(0) == '/') {
            return value.substring(1);
        }
        return value;
    }

    private String getDefaultName(ObjectName actualName) {
        Hashtable<String, String> keyProperties = actualName.getKeyPropertyList();
        String type = (String)keyProperties.remove("type");
        StringBuilder rootPath = new StringBuilder("JMX").append('/');
        if (actualName.getDomain() != null) {
            rootPath.append(actualName.getDomain()).append('/');
        }
        rootPath.append(type);
        if (keyProperties.size() > 1) {
            String str = this.getObjectNameString();
            Matcher matcher = TYPE_QUERY_PATTERN.matcher(str);
            while (matcher.find()) {
                String group = matcher.group(1);
                String val = (String)keyProperties.remove(group);
                if (val == null) continue;
                rootPath.append('/');
                rootPath.append(JmxGet.formatSegment(val));
            }
        }
        if (keyProperties.size() == 1) {
            rootPath.append('/');
            rootPath.append(JmxGet.formatSegment((String)keyProperties.entrySet().iterator().next().getValue()));
        }
        rootPath.append('/');
        return rootPath.toString();
    }

    private static String formatSegment(String metricSegment) {
        if (metricSegment.length() > 0 && metricSegment.charAt(0) == '/') {
            return metricSegment.substring(1);
        }
        return metricSegment;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("object_name: ").append(this.getObjectNameString());
        sb.append(" attributes: [");
        Iterator<JmxMetric> it = this.metrics.iterator();
        while (it.hasNext()) {
            JmxMetric metric = it.next();
            sb.append(metric.getAttributeMetricName()).append(" type: ").append(metric.getType().getYmlName());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public Extension getOrigin() {
        return this.origin;
    }

    protected JmxAttributeFilter getJmxAttributeFilter() {
        return this.attributeFilter;
    }

    protected List<JmxMetric> getJmxMetrics() {
        return this.metrics;
    }
}

