/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.frameworks.spring;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.frameworks.spring.MethodInvokerPointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import java.lang.reflect.Method;

@PointCut
public class HandlerMethodInvokerPointCut
extends MethodInvokerPointCut {
    private static final String SPRING_2X_METHOD = "doInvokeMethod";
    private static final String SPRING_3X_METHOD = "resolveHandlerArguments";

    public HandlerMethodInvokerPointCut(PointCutClassTransformer classTransformer) {
        super(new ExactClassMatcher("org/springframework/web/bind/annotation/support/HandlerMethodInvoker"), OrMethodMatcher.getMethodMatcher(HandlerMethodInvokerPointCut.createExactMethodMatcher(SPRING_2X_METHOD, "(Ljava/lang/reflect/Method;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;"), HandlerMethodInvokerPointCut.createExactMethodMatcher(SPRING_3X_METHOD, "(Ljava/lang/reflect/Method;Ljava/lang/Object;Lorg/springframework/web/context/request/NativeWebRequest;Lorg/springframework/ui/ExtendedModelMap;)[Ljava/lang/Object;")));
    }

    @Override
    public Tracer doGetTracer(final Transaction transaction, ClassMethodSignature sig, Object invoker, Object[] args) {
        final String methodName = ((Method)args[0]).getName();
        final Class<?> controller = args[1].getClass();
        this.setTransactionName(transaction, methodName, controller);
        if (SPRING_3X_METHOD.equals(sig.getMethodName())) {
            return null;
        }
        return new DefaultTracer(transaction, sig, invoker, new SimpleMetricNameFormat("Spring/Java/" + controller.getName() + '/' + methodName)){

            @Override
            protected void doFinish(Throwable throwable) {
                HandlerMethodInvokerPointCut.this.setTransactionName(transaction, methodName, controller);
            }
        };
    }
}

