/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension.util;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.extension.beans.Extension;
import com.newrelic.agent.extension.util.MethodMapper;
import com.newrelic.agent.extension.util.MethodMatcherUtility;
import com.newrelic.agent.extension.util.XmlException;
import com.newrelic.agent.instrumentation.InstrumentationType;
import com.newrelic.agent.instrumentation.classmatchers.AllClassesMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ChildClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.custom.ExtensionClassAndMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.AnnotationMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.tracing.ParameterAttributeName;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public final class ExtensionConversionUtility {
    public static final String DEFAULT_CONFIG_DIRECTORY = "extensions";

    private ExtensionConversionUtility() {
    }

    public static void validateExtensionAttributes(Extension extension) throws XmlException {
        if (extension == null) {
            throw new XmlException("There must be an extension to instrument new methods.\n");
        }
        if (extension.getName() == null || extension.getName().length() == 0) {
            throw new XmlException("The extension must have a name attribute.\n");
        }
        if (extension.getVersion() < 0.0) {
            throw new XmlException(" The version number must be a double and must be greater than or equal to 0.\n");
        }
    }

    private static void validateInstrument(Extension.Instrumentation instrument) throws XmlException {
        if (instrument == null) {
            throw new XmlException("In order to provide instrumentation, there must be an instrument tag.\n");
        }
        List<Extension.Instrumentation.Pointcut> pcs = instrument.getPointcut();
        if (pcs == null || pcs.isEmpty()) {
            throw new XmlException("A point cut tag is required to instrument a method.\n");
        }
    }

    public static List<ExtensionClassAndMethodMatcher> convertToPointCutsForValidation(Extension ext) throws XmlException {
        ArrayList<ExtensionClassAndMethodMatcher> pointCutsOut = new ArrayList<ExtensionClassAndMethodMatcher>();
        Extension.Instrumentation inst = ext.getInstrumentation();
        ExtensionConversionUtility.validateExtensionAttributes(ext);
        ExtensionConversionUtility.validateInstrument(inst);
        List<Extension.Instrumentation.Pointcut> pcs = inst.getPointcut();
        String defaultMetricPrefix = ExtensionConversionUtility.createDefaultMetricPrefix(inst, true);
        HashMap<String, MethodMapper> classesToMethods = new HashMap<String, MethodMapper>();
        for (Extension.Instrumentation.Pointcut pc : pcs) {
            pointCutsOut.add(ExtensionConversionUtility.createPointCut(ext, pc, defaultMetricPrefix, ext.getName(), classesToMethods, true, InstrumentationType.LocalCustomXml, false));
        }
        return pointCutsOut;
    }

    public static List<ExtensionClassAndMethodMatcher> convertToEnabledPointCuts(Collection<Extension> extensions, boolean custom, InstrumentationType type) {
        return ExtensionConversionUtility.convertToEnabledPointCuts(extensions, custom, type, true);
    }

    public static List<ExtensionClassAndMethodMatcher> convertToEnabledPointCuts(Collection<Extension> extensions, boolean custom, InstrumentationType type, boolean isAttsEnabled) {
        ArrayList<ExtensionClassAndMethodMatcher> pointCutsOut = new ArrayList<ExtensionClassAndMethodMatcher>();
        if (extensions != null) {
            HashMap<String, MethodMapper> classesToMethods = new HashMap<String, MethodMapper>();
            for (Extension ext : extensions) {
                if (ext.isEnabled()) {
                    pointCutsOut.addAll(ExtensionConversionUtility.convertToEnabledPointCuts(ext, ext.getName(), classesToMethods, custom, type, isAttsEnabled));
                    continue;
                }
                Agent.LOG.log(Level.WARNING, MessageFormat.format("Extension {0} is not enabled and so will not be instrumented.", ext.getName()));
            }
        }
        return pointCutsOut;
    }

    private static List<ExtensionClassAndMethodMatcher> convertToEnabledPointCuts(Extension extension, String extensionName, Map<String, MethodMapper> classesToMethods, boolean custom, InstrumentationType type, boolean isAttsEnabled) {
        ArrayList<ExtensionClassAndMethodMatcher> pointCutsOut = new ArrayList<ExtensionClassAndMethodMatcher>();
        if (extension != null) {
            String defaultMetricPrefix = ExtensionConversionUtility.createDefaultMetricPrefix(extension.getInstrumentation(), custom);
            List<Extension.Instrumentation.Pointcut> inCuts = extension.getInstrumentation().getPointcut();
            if (inCuts != null && !inCuts.isEmpty()) {
                for (Extension.Instrumentation.Pointcut cut : inCuts) {
                    try {
                        ExtensionClassAndMethodMatcher pc = ExtensionConversionUtility.createPointCut(extension, cut, defaultMetricPrefix, extensionName, classesToMethods, custom, type, isAttsEnabled);
                        if (pc == null) continue;
                        ExtensionConversionUtility.logPointCutCreation(pc);
                        pointCutsOut.add(pc);
                    }
                    catch (Exception e) {
                        String msg = MessageFormat.format("An error occurred reading in a pointcut in extension {0} : {1}", extensionName, e.toString());
                        Agent.LOG.log(Level.SEVERE, msg);
                        Agent.LOG.log(Level.FINER, msg, e);
                    }
                }
            } else {
                String msg = MessageFormat.format("There were no point cuts in the extension {0}.", extensionName);
                Agent.LOG.log(Level.INFO, msg);
            }
        }
        return pointCutsOut;
    }

    private static String createDefaultMetricPrefix(Extension.Instrumentation instrument, boolean custom) {
        String prefix;
        String metricPrefix;
        String string = metricPrefix = custom ? "Custom" : "Java";
        if (instrument != null && (prefix = instrument.getMetricPrefix()) != null && prefix.length() != 0) {
            metricPrefix = prefix;
        }
        return metricPrefix;
    }

    private static void logPointCutCreation(ExtensionClassAndMethodMatcher pc) {
        String msg = MessageFormat.format("Extension instrumentation point: {0} {1}", pc.getClassMatcher(), pc.getMethodMatcher());
        Agent.LOG.finest(msg);
    }

    private static ExtensionClassAndMethodMatcher createPointCut(Extension extension, Extension.Instrumentation.Pointcut cut, String metricPrefix, String pName, Map<String, MethodMapper> classesToMethods, boolean custom, InstrumentationType type, boolean isAttsEnabled) throws XmlException {
        ClassMatcher classMatcher = cut.getMethodAnnotation() != null ? new AllClassesMatcher() : ExtensionConversionUtility.createClassMatcher(cut, pName);
        MethodMatcher methodMatcher = ExtensionConversionUtility.createMethodMatcher(cut, pName, classesToMethods);
        List<Object> reportedParams = null;
        reportedParams = !isAttsEnabled ? Lists.newArrayList() : ExtensionConversionUtility.getParameterAttributeNames(cut.getMethod());
        return new ExtensionClassAndMethodMatcher(extension, cut, metricPrefix, classMatcher, methodMatcher, custom, reportedParams, type);
    }

    private static List<ParameterAttributeName> getParameterAttributeNames(List<Extension.Instrumentation.Pointcut.Method> methods) {
        ArrayList<ParameterAttributeName> reportedParams = Lists.newArrayList();
        for (Extension.Instrumentation.Pointcut.Method m : methods) {
            if (m.getParameters() == null || m.getParameters().getType() == null) continue;
            for (int i = 0; i < m.getParameters().getType().size(); ++i) {
                Extension.Instrumentation.Pointcut.Method.Parameters.Type t = m.getParameters().getType().get(i);
                if (t.getAttributeName() == null) continue;
                try {
                    MethodMatcher methodMatcher = MethodMatcherUtility.createMethodMatcher("DummyClassName", m, Maps.<String, MethodMapper>newHashMap(), "");
                    ParameterAttributeName reportedParam = new ParameterAttributeName(i, t.getAttributeName(), methodMatcher);
                    reportedParams.add(reportedParam);
                    continue;
                }
                catch (Exception e) {
                    Agent.LOG.log(Level.FINEST, e, e.getMessage(), new Object[0]);
                }
            }
        }
        return reportedParams;
    }

    private static MethodMatcher createMethodMatcher(Extension.Instrumentation.Pointcut cut, String pExtName, Map<String, MethodMapper> classesToMethods) throws XmlException {
        List<Extension.Instrumentation.Pointcut.Method> methods = cut.getMethod();
        if (methods != null && !methods.isEmpty()) {
            return MethodMatcherUtility.createMethodMatcher(ExtensionConversionUtility.getClassName(cut), methods, classesToMethods, pExtName);
        }
        if (cut.getMethodAnnotation() != null) {
            return new AnnotationMethodMatcher(Type.getObjectType(cut.getMethodAnnotation().replace('.', '/')));
        }
        throw new XmlException(MessageFormat.format("At least one method must be specified for each point cut in the extension {0}", pExtName));
    }

    static boolean isReturnTypeOkay(Type returnType) {
        if (returnType.getSort() == 9) {
            return ExtensionConversionUtility.isReturnTypeOkay(returnType.getElementType());
        }
        return returnType.getSort() == 10;
    }

    public static String getClassName(Extension.Instrumentation.Pointcut cut) {
        if (cut.getClassName() != null) {
            return cut.getClassName().getValue().trim();
        }
        if (cut.getInterfaceName() != null) {
            return cut.getInterfaceName().trim();
        }
        return null;
    }

    static ClassMatcher createClassMatcher(Extension.Instrumentation.Pointcut pointcut, String pExtName) throws XmlException {
        Extension.Instrumentation.Pointcut.ClassName className = pointcut.getClassName();
        if (className != null) {
            if (className.getValue() == null || className.getValue().isEmpty()) {
                throw new XmlException("");
            }
            if (className.isIncludeSubclasses()) {
                return new ChildClassMatcher(className.getValue(), false);
            }
            return new ExactClassMatcher(className.getValue());
        }
        if (pointcut.getInterfaceName() != null) {
            return new InterfaceMatcher(pointcut.getInterfaceName());
        }
        throw new XmlException(MessageFormat.format("A class name, interface name, or super class name needs to be specified for every point cut in the extension {0}", pExtName));
    }
}

