/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension;

import com.newrelic.agent.Agent;
import java.io.File;
import java.io.FileFilter;
import java.text.MessageFormat;

public class ExtensionFileFilter
implements FileFilter {
    private String fileExtension;

    public ExtensionFileFilter(String pFileExt) {
        this.fileExtension = pFileExt != null && pFileExt.length() != 0 && !pFileExt.startsWith(".") ? "." + pFileExt : pFileExt;
    }

    @Override
    public boolean accept(File pFile) {
        if (pFile == null || !pFile.isFile() || !pFile.getName().endsWith(this.fileExtension)) {
            return false;
        }
        if (!pFile.canRead()) {
            Agent.LOG.fine(MessageFormat.format("Unable to read file {0}. Check file permissions", pFile.getAbsolutePath()));
            return false;
        }
        return true;
    }
}

