/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.errors;

import com.newrelic.agent.TransactionData;
import com.newrelic.agent.config.ErrorCollectorConfig;
import com.newrelic.agent.config.ExpectedErrorConfig;
import com.newrelic.agent.errors.ErrorServiceImpl;
import com.newrelic.agent.errors.TracedError;
import com.newrelic.agent.instrumentation.pointcuts.container.jetty.MultiException;
import com.newrelic.agent.util.StackTraces;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ThrowableError
extends TracedError {
    private final Throwable throwable;

    protected ThrowableError(ErrorCollectorConfig errorCollectorConfig, String appName, String frontendMetricName, String requestUri, Throwable error, long timestamp, Map<String, Map<String, String>> prefixedParams, Map<String, Object> userParams, Map<String, Object> agentParams, Map<String, String> errorParams, Map<String, Object> intrinsics, TransactionData transactionData, boolean expected) {
        super(errorCollectorConfig, appName, frontendMetricName, timestamp, requestUri, prefixedParams, userParams, agentParams, errorParams, intrinsics, transactionData, expected);
        this.throwable = error;
    }

    public static Builder builder(ErrorCollectorConfig errorCollectorConfig, String appName, String frontendMetricName, Throwable throwable, long timestampInMillis) {
        return new Builder(errorCollectorConfig, appName, frontendMetricName, throwable, timestampInMillis);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public String getMessage() {
        String message;
        String string = message = this.throwable == null ? null : ErrorServiceImpl.getStrippedExceptionMessage(this.throwable);
        if (message == null) {
            return "";
        }
        return message;
    }

    @Override
    public String getExceptionClass() {
        return this.throwable == null ? null : this.throwable.getClass().getName();
    }

    @Override
    public Collection<String> stackTrace() {
        ArrayList<String> stackTrace = new ArrayList<String>();
        if (this.throwable instanceof MultiException) {
            List<Throwable> throwables = ((MultiException)((Object)this.throwable)).getThrowables();
            for (int i = 0; i < throwables.size(); ++i) {
                if (i > 0) {
                    stackTrace.add(" ");
                }
                stackTrace.addAll(StackTraces.stackTracesToStrings(throwables.get(i).getStackTrace()));
            }
        } else {
            Throwable t = this.throwable;
            boolean inner = false;
            while (t != null) {
                if (inner) {
                    stackTrace.add(" ");
                    stackTrace.add(" caused by " + t.toString());
                }
                stackTrace.addAll(StackTraces.stackTracesToStrings(t.getStackTrace()));
                t = t.equals(t.getCause()) ? null : t.getCause();
                inner = true;
            }
        }
        return stackTrace;
    }

    @Override
    public boolean incrementsErrorMetric() {
        if (this.expected) {
            return false;
        }
        boolean shouldIncrement = true;
        String exceptionClass = this.getExceptionClass();
        String exceptionMessage = this.getMessage();
        Set<ExpectedErrorConfig> expectedErrors = this.errorCollectorConfig.getExpectedErrors();
        for (ExpectedErrorConfig expectedError : expectedErrors) {
            String expectedErrorClass = expectedError.getErrorClass();
            if (exceptionClass == null || !exceptionClass.equals(expectedErrorClass)) continue;
            String expectedErrorMessage = expectedError.getErrorMessage();
            if (expectedErrorMessage != null) {
                if (exceptionMessage == null || !exceptionMessage.contains(expectedErrorMessage)) continue;
                shouldIncrement = false;
                break;
            }
            shouldIncrement = false;
            break;
        }
        return shouldIncrement;
    }

    public String toString() {
        return this.getMessage();
    }

    public int hashCode() {
        return this.throwable.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThrowableError other = (ThrowableError)obj;
        return this.throwable.equals(other.throwable);
    }

    public static class Builder
    extends TracedError.Builder {
        private final Throwable throwable;

        Builder(ErrorCollectorConfig errorCollectorConfig, String appName, String frontendMetricName, Throwable throwable, long timestampInMillis) {
            super(errorCollectorConfig, appName, frontendMetricName, timestampInMillis);
            this.throwable = throwable;
        }

        @Override
        public ThrowableError build() {
            return new ThrowableError(this.errorCollectorConfig, this.appName, this.frontendMetricName, this.requestUri, this.throwable, this.timestampInMillis, this.prefixedAttributes, this.userAttributes, this.agentAttributes, this.errorAttributes, this.intrinsicAttributes, this.transactionData, this.expected);
        }
    }
}

