/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.errors;

import com.newrelic.agent.TransactionData;
import com.newrelic.agent.config.ErrorCollectorConfig;
import com.newrelic.agent.errors.TracedError;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;

public class HttpTracedError
extends TracedError {
    private static int UNKNOWN_STATUS_CODE = -1;
    private final int responseStatus;
    private final String errorMessage;

    private HttpTracedError(ErrorCollectorConfig errorCollectorConfig, String appName, String frontendMetricName, String requestUri, int responseStatus, String errorMessage, long timestamp, Map<String, Map<String, String>> prefixedParams, Map<String, Object> userParams, Map<String, Object> agentParams, Map<String, String> errorParams, Map<String, Object> intrinsics, TransactionData transactionData, boolean expected) {
        super(errorCollectorConfig, appName, frontendMetricName, timestamp, requestUri, prefixedParams, userParams, agentParams, errorParams, intrinsics, transactionData, expected);
        this.responseStatus = responseStatus;
        this.errorMessage = errorMessage == null && responseStatus != UNKNOWN_STATUS_CODE ? (responseStatus >= 400 && responseStatus < 500 ? "HttpClientError " + responseStatus : "HttpServerError " + responseStatus) : errorMessage;
    }

    public static HttpTracedErrorRequired builder(ErrorCollectorConfig errorCollectorConfig, String appName, String frontendMetricName, long timestampInMillis) {
        return new Builder(errorCollectorConfig, appName, frontendMetricName, timestampInMillis);
    }

    @Override
    public Collection<String> stackTrace() {
        return null;
    }

    @Override
    public String getExceptionClass() {
        return this.getMessage();
    }

    @Override
    public String getMessage() {
        return this.errorMessage;
    }

    public int getStatusCode() {
        return this.responseStatus;
    }

    @Override
    public boolean incrementsErrorMetric() {
        boolean isExpectedStatusCode = this.errorCollectorConfig.getExpectedStatusCodes().contains(this.responseStatus);
        return !this.expected && !isExpectedStatusCode;
    }

    public String toString() {
        return MessageFormat.format("{0} ({1})", this.getMessage(), this.responseStatus);
    }

    public static interface HttpTracedErrorRequired {
        public Builder statusCodeAndMessage(int var1, String var2);

        public Builder message(String var1);
    }

    public static class Builder
    extends TracedError.Builder
    implements HttpTracedErrorRequired {
        private int responseStatus;
        private String errorMessage;

        Builder(ErrorCollectorConfig errorCollectorConfig, String appName, String frontendMetricName, long timestampInMillis) {
            super(errorCollectorConfig, appName, frontendMetricName, timestampInMillis);
        }

        @Override
        public Builder statusCodeAndMessage(int responseStatus, String errorMessage) {
            this.responseStatus = responseStatus;
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public Builder message(String errorMessage) {
            this.responseStatus = UNKNOWN_STATUS_CODE;
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public HttpTracedError build() {
            return new HttpTracedError(this.errorCollectorConfig, this.appName, this.frontendMetricName, this.requestUri, this.responseStatus, this.errorMessage, this.timestampInMillis, this.prefixedAttributes, this.userAttributes, this.agentAttributes, this.errorAttributes, this.intrinsicAttributes, this.transactionData, this.expected);
        }
    }
}

