/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.circuitbreaker;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.RPMService;
import com.newrelic.agent.circuitbreaker.SamplingCounter;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigListener;
import com.newrelic.agent.config.CircuitBreakerConfig;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryManagerMXBean;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public class CircuitBreakerService
extends AbstractService
implements HarvestListener,
AgentConfigListener {
    private static final int TRACER_SAMPLING_RATE = 1000;
    private volatile int tripped = 0;
    private final CircuitBreakerConfig circuitBreakerConfig;
    private volatile GarbageCollectorMXBean oldGenGCBeanCached = null;
    private final ReentrantLock lock = new ReentrantLock();
    private final ConcurrentMap<String, Boolean> missingData;
    private final ThreadLocal<Boolean> logWarning = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    private final ThreadLocal<Long> lastTotalGCTimeNS = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return CircuitBreakerService.this.getGCCpuTimeNS();
        }
    };
    private final ThreadLocal<Long> lastTimestampInNanoseconds = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return System.nanoTime();
        }
    };
    private final ThreadLocal<SamplingCounter> tracerSamplerCounter = new ThreadLocal<SamplingCounter>(){

        @Override
        protected SamplingCounter initialValue() {
            return CircuitBreakerService.createTracerSamplerCounter();
        }
    };

    public CircuitBreakerService() {
        super(CircuitBreakerService.class.getSimpleName());
        this.circuitBreakerConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getCircuitBreakerConfig();
        if (this.isEnabled() && null == this.getOldGenGCBean()) {
            Agent.LOG.log(Level.WARNING, "Circuit breaker: Missing required JMX beans. Cannot enable circuit breaker. GC bean: {0}", new Object[]{this.getOldGenGCBean()});
            this.circuitBreakerConfig.updateEnabled(false);
        }
        ServiceFactory.getConfigService().addIAgentConfigListener(this);
        this.missingData = new ConcurrentHashMap<String, Boolean>();
    }

    @Override
    public boolean isEnabled() {
        return this.circuitBreakerConfig.isEnabled();
    }

    @Override
    protected void doStart() throws Exception {
        ServiceFactory.getHarvestService().addHarvestListener(this);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getConfigService().removeIAgentConfigListener(this);
        ServiceFactory.getHarvestService().removeHarvestListener(this);
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
        this.lastTimestampInNanoseconds.set(System.nanoTime());
        this.lastTotalGCTimeNS.set(this.getGCCpuTimeNS());
        if (this.missingData.containsKey(appName) && ((Boolean)this.missingData.get(appName)).booleanValue()) {
            this.recordBreakerOnMetrics(statsEngine, "AgentCheck/CircuitBreaker/tripped/memory");
        } else {
            this.recordBreakerOffMetrics(statsEngine);
        }
    }

    private void recordBreakerOnMetrics(StatsEngine statsEngine, String tripCauseMetric) {
        statsEngine.getStats("AgentCheck/CircuitBreaker/tripped/all").incrementCallCount();
        statsEngine.getStats(tripCauseMetric).incrementCallCount();
    }

    private void recordBreakerOffMetrics(StatsEngine statsEngine) {
        statsEngine.recordEmptyStats("AgentCheck/CircuitBreaker/tripped/all");
    }

    @Override
    public void afterHarvest(String appName) {
        if (this.isTripped() && this.shouldReset()) {
            this.reset();
        }
        if (!this.isTripped()) {
            this.missingData.put(appName, false);
            if (this.isTripped()) {
                this.missingData.put(appName, true);
            }
        }
    }

    private boolean shouldTrip() {
        if (!this.isEnabled()) {
            return false;
        }
        long currentTimeInNanoseconds = System.nanoTime();
        long gcCpuTime = this.getGCCpuTimeNS() - this.lastTotalGCTimeNS.get();
        long elapsedTime = currentTimeInNanoseconds - this.lastTimestampInNanoseconds.get();
        double gcCpuTimePercentage = (double)gcCpuTime / (double)elapsedTime * 100.0;
        if (elapsedTime <= 0L) {
            return false;
        }
        double percentageFreeMemory = 100.0 * ((double)(Runtime.getRuntime().freeMemory() + (Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory())) / (double)Runtime.getRuntime().maxMemory());
        this.lastTimestampInNanoseconds.set(currentTimeInNanoseconds);
        this.lastTotalGCTimeNS.set(this.lastTotalGCTimeNS.get() + gcCpuTime);
        int freeMemoryThreshold = this.circuitBreakerConfig.getMemoryThreshold();
        int gcCPUThreshold = this.circuitBreakerConfig.getGcCpuThreshold();
        Agent.LOG.log(Level.FINEST, "Circuit breaker: percentage free memory {0}%  GC CPU time percentage {1}% (freeMemoryThreshold {2}, gcCPUThreshold {3})", new Object[]{percentageFreeMemory, gcCpuTimePercentage, freeMemoryThreshold, gcCPUThreshold});
        if (gcCpuTimePercentage >= (double)gcCPUThreshold && percentageFreeMemory <= (double)freeMemoryThreshold) {
            Agent.LOG.log(Level.WARNING, "Circuit breaker tripped at memory {0}%  GC CPU time {1}%", new Object[]{percentageFreeMemory, gcCpuTimePercentage});
            return true;
        }
        return false;
    }

    private boolean shouldReset() {
        return !this.shouldTrip();
    }

    public boolean isTripped() {
        if (this.isEnabled() && this.tracerSamplerCounter.get().shouldSample() && this.tripped == 0) {
            this.checkAndTrip();
        }
        return this.tripped == 1;
    }

    private void trip() {
        this.tripped = 1;
        for (String appName : this.missingData.keySet()) {
            this.missingData.put(appName, true);
        }
        if (this.logWarning.get().booleanValue()) {
            this.logWarning.set(false);
            Agent.LOG.log(Level.WARNING, "Circuit breaker tripped. The agent ceased to create transaction data to perserve heap memory. This may cause incomplete transaction data in the APM UI.");
        }
    }

    public void reset() {
        this.tripped = 0;
        Agent.LOG.log(Level.FINE, "Circuit breaker reset");
        this.logWarning.set(true);
    }

    public boolean checkAndTrip() {
        if (this.lock.tryLock()) {
            try {
                if (!this.isTripped() && this.shouldTrip()) {
                    this.trip();
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    private long getGCCpuTimeNS() {
        return TimeUnit.NANOSECONDS.convert(this.getOldGenGCBean().getCollectionTime(), TimeUnit.MILLISECONDS);
    }

    private long getGCCount() {
        long gcCpuCount = 0L;
        long collectorCount = 0L;
        for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            collectorCount = gcBean.getCollectionCount();
            if (collectorCount == -1L) continue;
            gcCpuCount += gcBean.getCollectionCount();
        }
        return gcCpuCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GarbageCollectorMXBean getOldGenGCBean() {
        if (null != this.oldGenGCBeanCached) {
            return this.oldGenGCBeanCached;
        }
        CircuitBreakerService circuitBreakerService = this;
        synchronized (circuitBreakerService) {
            if (null != this.oldGenGCBeanCached) {
                return this.oldGenGCBeanCached;
            }
            MemoryManagerMXBean lowestGCCountBean = null;
            Agent.LOG.log(Level.FINEST, "Circuit breaker: looking for old gen gc bean");
            boolean tie = false;
            long totalGCs = this.getGCCount();
            for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
                Agent.LOG.log(Level.FINEST, "Circuit breaker: checking {0}", new Object[]{gcBean.getName()});
                if (null == lowestGCCountBean || lowestGCCountBean.getCollectionCount() > gcBean.getCollectionCount()) {
                    tie = false;
                    lowestGCCountBean = gcBean;
                    continue;
                }
                if (lowestGCCountBean.getCollectionCount() != gcBean.getCollectionCount()) continue;
                tie = true;
            }
            if (this.getGCCount() == totalGCs && !tie) {
                Agent.LOG.log(Level.FINEST, "Circuit breaker: found and cached oldGenGCBean: {0}", new Object[]{lowestGCCountBean.getName()});
                this.oldGenGCBeanCached = lowestGCCountBean;
                return this.oldGenGCBeanCached;
            }
            Agent.LOG.log(Level.FINEST, "Circuit breaker: unable to find oldGenGCBean. Best guess: {0}", new Object[]{lowestGCCountBean.getName()});
            return lowestGCCountBean;
        }
    }

    @Override
    public void configChanged(String appName, AgentConfig agentConfig) {
        int newGCCpuThreshold = agentConfig.getCircuitBreakerConfig().getGcCpuThreshold();
        int newMemoryThreshold = agentConfig.getCircuitBreakerConfig().getMemoryThreshold();
        boolean newEnabled = agentConfig.getCircuitBreakerConfig().isEnabled();
        if (newGCCpuThreshold == this.circuitBreakerConfig.getGcCpuThreshold() && newMemoryThreshold == this.circuitBreakerConfig.getMemoryThreshold() && newEnabled == this.circuitBreakerConfig.isEnabled()) {
            return;
        }
        this.circuitBreakerConfig.updateEnabled(newEnabled);
        this.circuitBreakerConfig.updateThresholds(newGCCpuThreshold, newMemoryThreshold);
        Agent.LOG.log(Level.INFO, "Circuit breaker: updated configuration - enabled {0} GC CPU Threshold {1}% Memory Threshold {2}%.", new Object[]{this.circuitBreakerConfig.isEnabled(), this.circuitBreakerConfig.getGcCpuThreshold(), this.circuitBreakerConfig.getMemoryThreshold()});
    }

    public void addRPMService(RPMService rpmService) {
        this.missingData.put(rpmService.getApplicationName(), this.isTripped());
    }

    public void removeRPMService(RPMService rpmService) {
        this.missingData.remove(rpmService.getApplicationName());
    }

    public void setPreviousChecksForTesting(long newGCTimeNS, long newCpuTimeNS) {
        this.lastTotalGCTimeNS.set(newGCTimeNS);
        this.lastTimestampInNanoseconds.set(newCpuTimeNS);
    }

    public static SamplingCounter createTracerSamplerCounter() {
        return new SamplingCounter(1000L);
    }
}

