/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.attributes;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class AttributesConfigUtil {
    protected static final String[] DEFAULT_BROWSER_EXCLUDES = new String[]{"request.parameters.*", "message.parameters.*", "library.solr.*", "jvm.*", "httpResponseMessage", "request.headers.referer", "httpResponseCode", "host.displayName", "process.instanceName", "request.headers.accept", "request.headers.host", "request.headers.userAgent", "request.method", "response.headers.contentType", "request.headers.contentLength"};
    protected static final String[] DEFAULT_EVENTS_EXCLUDES = new String[]{"request.parameters.*", "message.parameters.*", "library.solr.*", "jvm.*", "httpResponseMessage"};
    protected static final String[] DEFAULT_ERRORS_EXCLUDES = new String[0];
    protected static final String[] DEFAULT_TRACES_EXCLUDES = new String[0];
    public static final String IGNORED_PARAMS = "ignored_params";
    public static final String IGNORED_MESSAGING_PARAMS = "ignored_messaging_params";
    protected static final String ATTS_ENABLED = "attributes.enabled";
    protected static final String ATTS_EXCLUDE = "attributes.exclude";
    protected static final String ATTS_INCLUDE = "attributes.include";
    protected static final String CAPTURE_ATTRIBUTES = ".capture_attributes";

    protected static boolean isCaptureAttributes(AgentConfig config) {
        return AttributesConfigUtil.getBooleanValue(config, "capture_params", Boolean.FALSE);
    }

    protected static boolean isCaptureMessageAttributes(AgentConfig config) {
        return AttributesConfigUtil.getBooleanValue(config, "capture_messaging_params", Boolean.FALSE);
    }

    protected static boolean isAttsEnabled(AgentConfig config, boolean defaultProp, String ... dest) {
        Boolean enabledRoot = (Boolean)config.getValue(ATTS_ENABLED);
        if (enabledRoot != null && !enabledRoot.booleanValue()) {
            return enabledRoot;
        }
        boolean toEnable = false;
        Boolean destEnabled = null;
        for (String current : dest) {
            destEnabled = AttributesConfigUtil.getBooleanValue(config, current + "." + ATTS_ENABLED);
            if (destEnabled == null) continue;
            if (!destEnabled.booleanValue()) {
                return destEnabled;
            }
            toEnable = true;
        }
        boolean toCapture = false;
        for (String current : dest) {
            destEnabled = AttributesConfigUtil.getBooleanValue(config, current + CAPTURE_ATTRIBUTES);
            if (destEnabled == null) continue;
            if (!destEnabled.booleanValue()) {
                return destEnabled;
            }
            toCapture = true;
        }
        return toEnable || toCapture ? true : defaultProp;
    }

    private static Boolean getBooleanValue(AgentConfig config, String value) {
        return AttributesConfigUtil.getBooleanValue(config, value, null);
    }

    private static Boolean getBooleanValue(AgentConfig config, String value, Object theDefault) {
        try {
            Object inputObj = config.getValue(value, theDefault);
            if (inputObj != null) {
                if (inputObj instanceof Boolean) {
                    return (Boolean)inputObj;
                }
                if (inputObj instanceof String) {
                    return Boolean.parseBoolean((String)inputObj);
                }
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, MessageFormat.format("The configuration property {0} should be a boolean but is not.", value));
        }
        return null;
    }

    protected static List<String> getBaseList(AgentConfig config, String key, String prefix) {
        Object val = config.getValue(key);
        if (val instanceof String) {
            return BaseConfig.getUniqueStringsFromString((String)val, ",", prefix);
        }
        if (val instanceof Collection) {
            return BaseConfig.getUniqueStringsFromCollection((Collection)val, prefix);
        }
        return Collections.emptyList();
    }

    protected static List<String> getBaseList(AgentConfig config, String key) {
        return AttributesConfigUtil.getBaseList(config, key, null);
    }

    protected static Set<String> getExcluded(AgentConfig config, List<String> baseList, String dest) {
        HashSet<String> output = Sets.newHashSet();
        output.addAll(baseList);
        output.addAll(AttributesConfigUtil.getBaseList(config, dest + "." + ATTS_EXCLUDE));
        return output;
    }

    protected static Set<String> getIncluded(AgentConfig config, List<String> baseList, String dest) {
        HashSet<String> output = Sets.newHashSet();
        output.addAll(baseList);
        output.addAll(AttributesConfigUtil.getBaseList(config, dest + "." + ATTS_INCLUDE));
        return output;
    }
}

