/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile.visitor;

import com.newrelic.agent.compile.InstrumentationContext;
import com.newrelic.agent.util.AnnotationImpl;
import com.newrelic.org.objectweb.asm.Type;
import org.slf4j.Logger;

public class TraceAnnotationVisitor
extends AnnotationImpl {
    final Logger log;
    final InstrumentationContext context;

    public TraceAnnotationVisitor(String name, InstrumentationContext context) {
        super(name);
        this.context = context;
        this.log = context.getLog();
    }

    @Override
    public void visitEnum(String parameterName, String desc, String value) {
        super.visitEnum(parameterName, desc, value);
        String className = Type.getType(desc).getClassName();
        this.context.addTracedMethodParameter(this.getName(), parameterName, className, value);
    }

    @Override
    public void visit(String parameterName, Object value) {
        super.visit(parameterName, value);
        String className = value.getClass().getName();
        this.context.addTracedMethodParameter(this.getName(), parameterName, className, value.toString());
    }
}

