/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile.transformers;

import com.newrelic.agent.InstrumentationAgent;
import com.newrelic.agent.compile.ClassAdapterBase;
import com.newrelic.agent.compile.ClassVisitorFactory;
import com.newrelic.agent.compile.MethodVisitorFactory;
import com.newrelic.agent.compile.PatchedClassWriter;
import com.newrelic.agent.compile.SkipException;
import com.newrelic.agent.compile.transformers.NewRelicClassTransformer;
import com.newrelic.agent.compile.visitor.BaseMethodVisitor;
import com.newrelic.org.objectweb.asm.ClassReader;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.MethodVisitor;
import com.newrelic.org.objectweb.asm.Type;
import com.newrelic.org.objectweb.asm.commons.Method;
import java.net.URISyntaxException;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

@Deprecated
public final class ClassRewriterTransformer
implements NewRelicClassTransformer {
    private final Logger log;
    private final Map<String, ClassVisitorFactory> classVisitors;

    public ClassRewriterTransformer(final Logger log) throws URISyntaxException {
        try {
            String string = InstrumentationAgent.getAgentJarPath();
        }
        catch (URISyntaxException e) {
            log.error("Unable to get the path to the New Relic class rewriter jar", e);
            throw e;
        }
        this.log = log;
        this.classVisitors = new HashMap<String, ClassVisitorFactory>(){
            {
                this.put("com/newrelic/agent/compile/ClassTransformer", new ClassVisitorFactory(true){

                    @Override
                    public ClassVisitor create(ClassVisitor cv) {
                        return ClassRewriterTransformer.createTransformClassAdapter(cv, log);
                    }
                });
            }
        };
    }

    @Override
    public boolean modifies(Class<?> clazz) {
        Type t = Type.getType(clazz);
        return this.classVisitors.containsKey(t.getInternalName());
    }

    @Override
    public byte[] transform(ClassLoader classLoader, String className, Class<?> clazz, ProtectionDomain protectionDomain, byte[] bytes) {
        ClassVisitorFactory factory = this.classVisitors.get(className);
        if (factory != null) {
            if (clazz != null && !factory.isRetransformOkay()) {
                this.log.error("Cannot instrument " + className);
                return null;
            }
            this.log.debug("ClassTransformer: classloader[" + classLoader + "] className [" + className + "] clazz[" + clazz + "]");
            this.log.debug("ClassTransformer protectionDomain[" + protectionDomain + "]");
            this.log.debug("ClassTransformer: Patching[" + className + "]");
            try {
                ClassReader cr = new ClassReader(bytes);
                PatchedClassWriter cw = new PatchedClassWriter(3, classLoader);
                ClassVisitor adapter = factory.create(cw);
                cr.accept(adapter, 4);
                this.log.debug("ClassTransformer: Transformed[" + className + "] Bytes In[" + bytes.length + "] Bytes Out[" + cw.toByteArray().length + "]");
                return cw.toByteArray();
            }
            catch (SkipException cr) {
            }
            catch (Exception ex) {
                this.log.error("Error transforming class " + className, ex);
            }
        }
        return null;
    }

    private static ClassVisitor createTransformClassAdapter(ClassVisitor cw, Logger log) {
        return new ClassAdapterBase(log, cw, (Map<Method, MethodVisitorFactory>)new HashMap<Method, MethodVisitorFactory>(){
            {
                this.put(new Method("transformClassBytes", "(Ljava/lang/String;[B)[B"), new MethodVisitorFactory(){

                    @Override
                    public MethodVisitor create(MethodVisitor mv, int access, String name, String desc) {
                        return new BaseMethodVisitor(mv, access, name, desc){

                            @Override
                            protected void onMethodEnter() {
                                this.builder.loadInvocationDispatcher().loadInvocationDispatcherKey(InstrumentationAgent.getProxyInvocationKey("com/newrelic/agent/compile/ClassTransformer", this.methodName)).loadArgumentsArray(this.methodDesc).invokeDispatcher(false);
                                this.checkCast(Type.getType(byte[].class));
                                this.storeArg(1);
                            }
                        };
                    }
                });
            }
        });
    }
}

