/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile;

import java.util.Map;

public class Log {
    static final String TAG = "newrelic";
    final Level logLevel;
    final String name;

    public Log(Map<String, String> agentOptions) {
        String logLevelOpt = agentOptions.getOrDefault("loglevel", Level.WARN.name());
        this.logLevel = Level.valueOf(logLevelOpt);
        this.name = TAG;
    }

    protected void log(String level, String message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(Level level, String message) {
        if (this.isLevelEnabled(level)) {
            Log log = this;
            synchronized (log) {
                this.log(level.name(), message);
            }
        }
    }

    boolean isLevelEnabled(Level level) {
        return this.logLevel.value >= level.value;
    }

    public static enum Level {
        TRACE(5),
        DEBUG(4),
        INFO(3),
        WARN(2),
        ERROR(1),
        OFF(0);

        final int value;

        private Level(int newValue) {
            this.value = newValue;
        }
    }
}

