/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile;

import com.newrelic.agent.compile.ClassMethod;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;

public class ClassRemapperConfig {
    public static final String WRAP_METHOD_IDENTIFIER = "WRAP_METHOD:";
    public static final String REPLACE_CALL_SITE_IDENTIFIER = "REPLACE_CALL_SITE:";
    public static final String SHADOW_METHOD_IDENTIFIER = "SHADOW_METHOD:";
    private final Map<ClassMethod, ClassMethod> methodWrappers;
    private final Map<String, Collection<ClassMethod>> callSiteReplacements;
    private final Map<String, Collection<ClassMethod>> shadowMethods;

    public ClassRemapperConfig(Logger log) throws ClassNotFoundException {
        Map remappings = ClassRemapperConfig.getRemappings(log);
        this.methodWrappers = ClassRemapperConfig.getMethodWrappers(remappings, log);
        this.callSiteReplacements = ClassRemapperConfig.getCallSiteReplacements(remappings, log);
        this.shadowMethods = ClassRemapperConfig.getShadowMethods(remappings, log);
    }

    public ClassMethod getMethodWrapper(ClassMethod method) {
        return this.methodWrappers.get(method);
    }

    public Collection<ClassMethod> getCallSiteReplacements(String className, String methodName, String methodDesc) {
        ArrayList<ClassMethod> methods = new ArrayList<ClassMethod>();
        Collection<ClassMethod> matches = this.callSiteReplacements.get(MessageFormat.format("{0}:{1}", methodName, methodDesc));
        if (matches != null) {
            methods.addAll(matches);
        }
        if ((matches = this.callSiteReplacements.get(MessageFormat.format("{0}.{1}:{2}", className, methodName, methodDesc))) != null) {
            methods.addAll(matches);
        }
        return methods;
    }

    public Collection<ClassMethod> getShadowMethods(String className, String methodName, String methodDesc) {
        ArrayList<ClassMethod> methods = new ArrayList<ClassMethod>();
        Collection<ClassMethod> matches = this.shadowMethods.get(MessageFormat.format("{0}:{1}", methodName, methodDesc));
        if (matches != null) {
            methods.addAll(matches);
        }
        if ((matches = this.shadowMethods.get(MessageFormat.format("{0}.{1}:{2}", className, methodName, methodDesc))) != null) {
            methods.addAll(matches);
        }
        return methods;
    }

    private static Map<ClassMethod, ClassMethod> getMethodWrappers(Map<String, String> remappings, Logger log) throws ClassNotFoundException {
        HashMap<ClassMethod, ClassMethod> methodWrappers = new HashMap<ClassMethod, ClassMethod>();
        for (Map.Entry<String, String> entry : remappings.entrySet()) {
            if (!entry.getKey().startsWith(WRAP_METHOD_IDENTIFIER)) continue;
            String originalSig = entry.getKey().substring(WRAP_METHOD_IDENTIFIER.length());
            ClassMethod origClassMethod = ClassMethod.getClassMethod(originalSig);
            ClassMethod wrappingMethod = ClassMethod.getClassMethod(entry.getValue());
            methodWrappers.put(origClassMethod, wrappingMethod);
        }
        return methodWrappers;
    }

    private static Map<String, Collection<ClassMethod>> getCallSiteReplacements(Map<String, String> remappings, Logger log) throws ClassNotFoundException {
        HashMap<String, HashSet<ClassMethod>> temp = new HashMap<String, HashSet<ClassMethod>>();
        for (Map.Entry<String, String> entry : remappings.entrySet()) {
            if (!entry.getKey().startsWith(REPLACE_CALL_SITE_IDENTIFIER)) continue;
            String originalSig = entry.getKey().substring(REPLACE_CALL_SITE_IDENTIFIER.length());
            if (originalSig.contains(".")) {
                ClassMethod origClassMethod = ClassMethod.getClassMethod(originalSig);
                ClassMethod replacement = ClassMethod.getClassMethod(entry.getValue());
                String key = MessageFormat.format("{0}.{1}:{2}", origClassMethod.getClassName(), origClassMethod.getMethodName(), origClassMethod.getMethodDesc());
                HashSet<ClassMethod> replacements = (HashSet<ClassMethod>)temp.get(key);
                if (replacements == null) {
                    replacements = new HashSet<ClassMethod>();
                    temp.put(key, replacements);
                }
                replacements.add(replacement);
                continue;
            }
            String[] nameDesc = originalSig.split(":");
            int paren = originalSig.indexOf("(");
            String methodName = originalSig.substring(0, paren);
            String methodDesc = originalSig.substring(paren);
            String key = MessageFormat.format("{0}:{1}", methodName, methodDesc);
            ClassMethod replacement = ClassMethod.getClassMethod(entry.getValue());
            HashSet<ClassMethod> replacements = (HashSet<ClassMethod>)temp.get(key);
            if (replacements == null) {
                replacements = new HashSet<ClassMethod>();
                temp.put(key, replacements);
            }
            replacements.add(replacement);
        }
        HashMap<String, Collection<ClassMethod>> callSiteReplacements = new HashMap<String, Collection<ClassMethod>>();
        for (Map.Entry entry : temp.entrySet()) {
            callSiteReplacements.put((String)entry.getKey(), (Collection)entry.getValue());
        }
        return callSiteReplacements;
    }

    private static Map<String, Collection<ClassMethod>> parseCallerRepl(Map<String, String> remappings, Logger log) throws ClassNotFoundException {
        HashMap<String, HashSet<ClassMethod>> temp = new HashMap<String, HashSet<ClassMethod>>();
        for (Map.Entry<String, String> entry : remappings.entrySet()) {
            if (!entry.getKey().startsWith(REPLACE_CALL_SITE_IDENTIFIER)) continue;
            String originalSig = entry.getKey().substring(REPLACE_CALL_SITE_IDENTIFIER.length());
            if (originalSig.contains(".")) {
                ClassMethod origClassMethod = ClassMethod.getClassMethod(originalSig);
                ClassMethod replacement = ClassMethod.getClassMethod(entry.getValue());
                String key = MessageFormat.format("{0}.{1}:{2}", origClassMethod.getClassName(), origClassMethod.getMethodName(), origClassMethod.getMethodDesc());
                HashSet<ClassMethod> replacements = (HashSet<ClassMethod>)temp.get(key);
                if (replacements == null) {
                    replacements = new HashSet<ClassMethod>();
                    temp.put(key, replacements);
                }
                replacements.add(replacement);
                continue;
            }
            String[] nameDesc = originalSig.split(":");
            int paren = originalSig.indexOf("(");
            String methodName = originalSig.substring(0, paren);
            String methodDesc = originalSig.substring(paren);
            String key = MessageFormat.format("{0}:{1}", methodName, methodDesc);
            ClassMethod replacement = ClassMethod.getClassMethod(entry.getValue());
            HashSet<ClassMethod> replacements = (HashSet<ClassMethod>)temp.get(key);
            if (replacements == null) {
                replacements = new HashSet<ClassMethod>();
                temp.put(key, replacements);
            }
            replacements.add(replacement);
        }
        HashMap<String, Collection<ClassMethod>> callSiteReplacements = new HashMap<String, Collection<ClassMethod>>();
        for (Map.Entry entry : temp.entrySet()) {
            callSiteReplacements.put((String)entry.getKey(), (Collection)entry.getValue());
        }
        return callSiteReplacements;
    }

    private static Map<String, Collection<ClassMethod>> getShadowMethods(Map<String, String> remappings, Logger log) throws ClassNotFoundException {
        HashMap<String, HashSet<ClassMethod>> temp = new HashMap<String, HashSet<ClassMethod>>();
        for (Map.Entry<String, String> entry : remappings.entrySet()) {
            if (!entry.getKey().startsWith(SHADOW_METHOD_IDENTIFIER)) continue;
            String originalSig = entry.getKey().substring(SHADOW_METHOD_IDENTIFIER.length());
            if (originalSig.contains(".")) {
                ClassMethod origClassMethod = ClassMethod.getClassMethod(originalSig);
                ClassMethod replacement = ClassMethod.getClassMethod(entry.getValue());
                String key = MessageFormat.format("{0}.{1}:{2}", origClassMethod.getClassName(), origClassMethod.getMethodName(), origClassMethod.getMethodDesc());
                HashSet<ClassMethod> replacements = (HashSet<ClassMethod>)temp.get(key);
                if (replacements == null) {
                    replacements = new HashSet<ClassMethod>();
                    temp.put(key, replacements);
                }
                replacements.add(replacement);
                continue;
            }
            String[] nameDesc = originalSig.split(":");
            int paren = originalSig.indexOf("(");
            String methodName = originalSig.substring(0, paren);
            String methodDesc = originalSig.substring(paren);
            String key = MessageFormat.format("{0}:{1}", methodName, methodDesc);
            ClassMethod replacement = ClassMethod.getClassMethod(entry.getValue());
            HashSet<ClassMethod> replacements = (HashSet<ClassMethod>)temp.get(key);
            if (replacements == null) {
                replacements = new HashSet<ClassMethod>();
                temp.put(key, replacements);
            }
            replacements.add(replacement);
        }
        HashMap<String, Collection<ClassMethod>> callSiteReplacements = new HashMap<String, Collection<ClassMethod>>();
        for (Map.Entry entry : temp.entrySet()) {
            callSiteReplacements.put((String)entry.getKey(), (Collection)entry.getValue());
        }
        return callSiteReplacements;
    }

    private static Map getRemappings(Logger log) {
        Properties props = new Properties();
        URL resource = ClassRemapperConfig.class.getResource("/type_map.properties");
        if (resource == null) {
            log.error("Unable to find the type map");
            System.exit(1);
        }
        try (InputStream in = resource.openStream();){
            props.load(in);
        }
        catch (Throwable ex) {
            log.error("Unable to read the type map", ex);
            System.exit(1);
        }
        return props;
    }
}

