/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mariadb.jdbc.CallParameter;
import org.mariadb.jdbc.MySQLConnection;
import org.mariadb.jdbc.internal.common.Utils;

class CallableParameterMetaData
implements ParameterMetaData {
    CallParameter[] params;
    MySQLConnection con;
    String name;
    boolean valid;
    boolean isFunction;
    boolean noAccessToMetadata;
    static Pattern PARAMETER_PATTERN = Pattern.compile("\\s*(IN\\s+|OUT\\s+|INOUT\\s+)?([\\w\\d]+)\\s+(UNSIGNED\\s+)?(\\w+)\\s*(\\([\\d]+\\))?\\s*", 2);
    static Pattern RETURN_PATTERN = Pattern.compile("\\s*(UNSIGNED\\s+)?(\\w+)\\s*(\\([\\d]+\\))?\\s*", 2);

    public CallableParameterMetaData(CallParameter[] params, MySQLConnection con, String name, boolean isFunction) {
        this.params = params;
        this.con = con;
        this.name = name;
        this.isFunction = isFunction;
    }

    public void readMetadataFromDBIfRequired() throws SQLException {
        if (this.noAccessToMetadata || this.valid) {
            return;
        }
        try {
            this.readMetadata();
            this.valid = true;
        }
        catch (SQLException e) {
            this.noAccessToMetadata = true;
            throw e;
        }
    }

    int mapMySQLTypeToJDBC(String t2) {
        if ((t2 = t2.toUpperCase()).equals("BIT")) {
            return -7;
        }
        if (t2.equals("TINYINT")) {
            return -6;
        }
        if (t2.equals("SMALLINT")) {
            return 5;
        }
        if (t2.equals("MEDIUMINT")) {
            return 4;
        }
        if (t2.equals("INT")) {
            return 4;
        }
        if (t2.equals("INTEGER")) {
            return 4;
        }
        if (t2.equals("LONG")) {
            return 4;
        }
        if (t2.equals("BIGINT")) {
            return -5;
        }
        if (t2.equals("INT24")) {
            return 4;
        }
        if (t2.equals("REAL")) {
            return 8;
        }
        if (t2.equals("FLOAT")) {
            return 6;
        }
        if (t2.equals("DECIMAL")) {
            return 3;
        }
        if (t2.equals("NUMERIC")) {
            return 2;
        }
        if (t2.equals("DOUBLE")) {
            return 8;
        }
        if (t2.equals("CHAR")) {
            return 1;
        }
        if (t2.equals("VARCHAR")) {
            return 12;
        }
        if (t2.equals("DATE")) {
            return 91;
        }
        if (t2.equals("TIME")) {
            return 92;
        }
        if (t2.equals("YEAR")) {
            return 5;
        }
        if (t2.equals("TIMESTAMP")) {
            return 93;
        }
        if (t2.equals("DATETIME")) {
            return 93;
        }
        if (t2.equals("TINYBLOB")) {
            return -2;
        }
        if (t2.equals("BLOB")) {
            return -4;
        }
        if (t2.equals("MEDIUMBLOB")) {
            return -4;
        }
        if (t2.equals("LONGBLOB")) {
            return -4;
        }
        if (t2.equals("TINYTEXT")) {
            return 12;
        }
        if (t2.equals("TEXT")) {
            return -1;
        }
        if (t2.equals("MEDIUMTEXT")) {
            return -1;
        }
        if (t2.equals("LONGTEXT")) {
            return -1;
        }
        if (t2.equals("ENUM")) {
            return 12;
        }
        if (t2.equals("SET")) {
            return 12;
        }
        if (t2.equals("GEOMETRY")) {
            return -4;
        }
        if (t2.equals("VARBINARY")) {
            return -3;
        }
        if (t2.equals("BIT")) {
            return -7;
        }
        return 1111;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMetadata() throws SQLException {
        int paramIndex;
        String functionReturn;
        String paramList;
        if (this.noAccessToMetadata || this.valid) {
            return;
        }
        boolean noBackslashEscapes = false;
        if (this.con instanceof MySQLConnection) {
            noBackslashEscapes = this.con.noBackslashEscapes;
        }
        String dbname = "database()";
        String procedureNameNoDb = this.name;
        int dotIndex = this.name.indexOf(46);
        if (dotIndex > 0) {
            dbname = this.name.substring(0, dotIndex);
            dbname = dbname.replace("`", "");
            dbname = "'" + Utils.escapeString(dbname, noBackslashEscapes) + "'";
            procedureNameNoDb = this.name.substring(dotIndex + 1);
        }
        procedureNameNoDb = procedureNameNoDb.replace("`", "");
        procedureNameNoDb = "'" + Utils.escapeString(procedureNameNoDb, noBackslashEscapes) + "'";
        Statement st = this.con.createStatement();
        ResultSet rs = null;
        try {
            String q = "select param_list,returns from mysql.proc where db=" + dbname + " and name=" + procedureNameNoDb;
            rs = st.executeQuery(q);
            if (!rs.next()) {
                throw new SQLException("procedure or function " + this.name + "does not exist");
            }
            paramList = rs.getString(1);
            functionReturn = rs.getString(2);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
        if (this.isFunction) {
            if (functionReturn == null || functionReturn.length() == 0) {
                throw new SQLException(this.name + "is not a function returning value");
            }
            Matcher m4 = RETURN_PATTERN.matcher(functionReturn);
            if (!m4.matches()) {
                throw new SQLException("can not parse return value definition :" + functionReturn);
            }
            CallParameter p = this.params[1];
            p.isOutput = true;
            p.isSigned = m4.group(1) == null;
            p.typeName = m4.group(2).trim();
            p.sqlType = this.mapMySQLTypeToJDBC(p.typeName);
            String scale = m4.group(3);
            if (scale != null) {
                scale = scale.replace("(", "").replace(")", "").replace(" ", "");
                p.scale = Integer.valueOf(scale);
            }
        }
        StringTokenizer tokenizer = new StringTokenizer(paramList, ",", false);
        int n = paramIndex = this.isFunction ? 2 : 1;
        while (tokenizer.hasMoreTokens()) {
            if (paramIndex >= this.params.length) {
                throw new SQLException("Invalid placeholder count in CallableStatement");
            }
            String paramDef = tokenizer.nextToken();
            Matcher m5 = PARAMETER_PATTERN.matcher(paramDef);
            if (!m5.matches()) {
                throw new SQLException("cannot parse parameter definition :" + paramDef);
            }
            String direction = m5.group(1);
            if (direction != null) {
                direction = direction.trim();
            }
            String paramName = m5.group(2);
            paramName = paramName.trim();
            boolean isSigned = m5.group(3) == null;
            String dataType = m5.group(4);
            dataType = dataType.trim();
            String scale = m5.group(5);
            if (scale != null) {
                scale = scale.trim();
            }
            CallParameter p = this.params[paramIndex];
            if (direction == null || direction.equalsIgnoreCase("IN")) {
                p.isInput = true;
            } else if (direction.equalsIgnoreCase("OUT")) {
                p.isOutput = true;
            } else if (direction.equalsIgnoreCase("INOUT")) {
                p.isOutput = true;
                p.isInput = true;
            } else {
                throw new SQLException("unknown parameter direction " + direction + "for " + paramName);
            }
            p.name = paramName;
            p.typeName = dataType.toUpperCase();
            p.sqlType = this.mapMySQLTypeToJDBC(p.typeName);
            p.isSigned = isSigned;
            if (scale != null) {
                scale = scale.replace("(", "").replace(")", "").replace(" ", "");
                p.scale = Integer.valueOf(scale);
            }
            ++paramIndex;
        }
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.params.length - 1;
    }

    CallParameter getParam(int index) throws SQLException {
        if (index < 1 || index >= this.params.length) {
            throw new SQLException("invalid parameter index " + index);
        }
        this.readMetadataFromDBIfRequired();
        return this.params[index];
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return this.getParam((int)param).isNullable;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        return this.getParam((int)param).isSigned;
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        return this.getParam((int)param).precision;
    }

    @Override
    public int getScale(int param) throws SQLException {
        return this.getParam((int)param).scale;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        return this.getParam((int)param).sqlType;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        return this.getParam((int)param).typeName;
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        return this.getParam((int)param).className;
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        CallParameter p = this.getParam(param);
        if (p.isInput && p.isOutput) {
            return 2;
        }
        if (p.isInput) {
            return 1;
        }
        if (p.isOutput) {
            return 4;
        }
        return 0;
    }

    public String getName(int param) throws SQLException {
        return this.getParam((int)param).name;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

