/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.UndertowLogger;
import io.undertow.connector.ByteBufferPool;
import io.undertow.util.Transfer;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import org.xnio.Buffers;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public final class WebSocketUtils {
    private static final String EMPTY = "";

    public static ByteBuffer fromUtf8String(CharSequence utfString) {
        if (utfString == null || utfString.length() == 0) {
            return Buffers.EMPTY_BYTE_BUFFER;
        }
        return ByteBuffer.wrap(utfString.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static String toUtf8String(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            return EMPTY;
        }
        if (buffer.hasArray()) {
            return new String(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining(), StandardCharsets.UTF_8);
        }
        byte[] content = new byte[buffer.remaining()];
        buffer.get(content);
        return new String(content, StandardCharsets.UTF_8);
    }

    public static String toUtf8String(ByteBuffer ... buffers) {
        int size = 0;
        for (ByteBuffer buf : buffers) {
            size += buf.remaining();
        }
        if (size == 0) {
            return EMPTY;
        }
        int index = 0;
        byte[] bytes = new byte[size];
        for (ByteBuffer buf : buffers) {
            int len;
            if (buf.hasArray()) {
                len = buf.remaining();
                System.arraycopy(buf.array(), buf.arrayOffset() + buf.position(), bytes, index, len);
                index += len;
                continue;
            }
            len = buf.remaining();
            buf.get(bytes, index, len);
            index += len;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long transfer(ReadableByteChannel source2, long count, ByteBuffer throughBuffer, WritableByteChannel sink2) throws IOException {
        long total = 0L;
        while (total < count) {
            long res;
            throughBuffer.clear();
            if (count - total < (long)throughBuffer.remaining()) {
                throughBuffer.limit((int)(count - total));
            }
            try {
                res = source2.read(throughBuffer);
                if (res <= 0L) {
                    long l = total == 0L ? res : total;
                    return l;
                }
            }
            finally {
                throughBuffer.flip();
            }
            while (throughBuffer.hasRemaining()) {
                res = sink2.write(throughBuffer);
                if (res <= 0L) {
                    return total;
                }
                total += res;
            }
        }
        return total;
    }

    public static void echoFrame(final WebSocketChannel channel, StreamSourceFrameChannel ws) throws IOException {
        WebSocketFrameType type;
        switch (ws.getType()) {
            case PONG: {
                ws.close();
                return;
            }
            case PING: {
                type = WebSocketFrameType.PONG;
                break;
            }
            default: {
                type = ws.getType();
            }
        }
        StreamSinkFrameChannel sink2 = channel.send(type);
        sink2.setRsv(ws.getRsv());
        WebSocketUtils.initiateTransfer(ws, sink2, new ChannelListener<StreamSourceFrameChannel>(){

            @Override
            public void handleEvent(StreamSourceFrameChannel streamSourceFrameChannel) {
                IoUtils.safeClose((Closeable)streamSourceFrameChannel);
            }
        }, new ChannelListener<StreamSinkFrameChannel>(){

            @Override
            public void handleEvent(StreamSinkFrameChannel streamSinkFrameChannel) {
                try {
                    streamSinkFrameChannel.shutdownWrites();
                }
                catch (IOException e) {
                    UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                    IoUtils.safeClose(streamSinkFrameChannel, channel);
                    return;
                }
                try {
                    if (!streamSinkFrameChannel.flush()) {
                        streamSinkFrameChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkFrameChannel>(){

                            @Override
                            public void handleEvent(StreamSinkFrameChannel streamSinkFrameChannel) {
                                streamSinkFrameChannel.getWriteSetter().set(null);
                                IoUtils.safeClose((Closeable)streamSinkFrameChannel);
                                if (type == WebSocketFrameType.CLOSE) {
                                    IoUtils.safeClose((Closeable)channel);
                                }
                            }
                        }, new ChannelExceptionHandler<StreamSinkFrameChannel>(){

                            @Override
                            public void handleException(StreamSinkFrameChannel streamSinkFrameChannel, IOException e) {
                                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                                IoUtils.safeClose(streamSinkFrameChannel, channel);
                            }
                        }));
                        streamSinkFrameChannel.resumeWrites();
                    } else {
                        if (type == WebSocketFrameType.CLOSE) {
                            IoUtils.safeClose((Closeable)channel);
                        }
                        streamSinkFrameChannel.getWriteSetter().set(null);
                        IoUtils.safeClose((Closeable)streamSinkFrameChannel);
                    }
                }
                catch (IOException e) {
                    UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                    IoUtils.safeClose(streamSinkFrameChannel, channel);
                }
            }
        }, new ChannelExceptionHandler<StreamSourceFrameChannel>(){

            @Override
            public void handleException(StreamSourceFrameChannel streamSourceFrameChannel, IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose(streamSourceFrameChannel, channel);
            }
        }, new ChannelExceptionHandler<StreamSinkFrameChannel>(){

            @Override
            public void handleException(StreamSinkFrameChannel streamSinkFrameChannel, IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose(streamSinkFrameChannel, channel);
            }
        }, channel.getBufferPool());
    }

    @Deprecated
    public static <I extends StreamSourceChannel, O extends StreamSinkChannel> void initiateTransfer(I source2, O sink2, ChannelListener<? super I> sourceListener, ChannelListener<? super O> sinkListener, ChannelExceptionHandler<? super I> readExceptionHandler, ChannelExceptionHandler<? super O> writeExceptionHandler, ByteBufferPool pool) {
        Transfer.initiateTransfer(source2, sink2, sourceListener, sinkListener, readExceptionHandler, writeExceptionHandler, pool);
    }

    private WebSocketUtils() {
    }
}

