/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.switcher;

import com.networknt.switcher.Switcher;
import com.networknt.switcher.SwitcherListener;
import com.networknt.switcher.SwitcherService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LocalSwitcherService
implements SwitcherService {
    private static ConcurrentMap<String, Switcher> switchers = new ConcurrentHashMap<String, Switcher>();
    private final Map<String, List<SwitcherListener>> listenerMap = new ConcurrentHashMap<String, List<SwitcherListener>>();

    @Override
    public Switcher getSwitcher(String name) {
        return (Switcher)switchers.get(name);
    }

    @Override
    public List<Switcher> getAllSwitchers() {
        return new ArrayList<Switcher>(switchers.values());
    }

    private void putSwitcher(Switcher switcher) {
        if (switcher == null) {
            throw new IllegalArgumentException("LocalSwitcherService addSwitcher Error: switcher is null");
        }
        switchers.put(switcher.getName(), switcher);
    }

    @Override
    public void initSwitcher(String switcherName, boolean initialValue) {
        this.setValue(switcherName, initialValue);
    }

    @Override
    public boolean isOpen(String switcherName) {
        Switcher switcher = (Switcher)switchers.get(switcherName);
        return switcher != null && switcher.isOn();
    }

    @Override
    public boolean isOpen(String switcherName, boolean defaultValue) {
        Switcher switcher = (Switcher)switchers.get(switcherName);
        if (switcher == null) {
            switchers.putIfAbsent(switcherName, new Switcher(switcherName, defaultValue));
            switcher = (Switcher)switchers.get(switcherName);
        }
        return switcher.isOn();
    }

    @Override
    public void setValue(String switcherName, boolean value) {
        this.putSwitcher(new Switcher(switcherName, value));
        List<SwitcherListener> listeners = this.listenerMap.get(switcherName);
        if (listeners != null) {
            for (SwitcherListener listener : listeners) {
                listener.onValueChanged(switcherName, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(String switcherName, SwitcherListener listener) {
        Map<String, List<SwitcherListener>> map = this.listenerMap;
        synchronized (map) {
            if (this.listenerMap.get(switcherName) == null) {
                List<SwitcherListener> listeners = Collections.synchronizedList(new ArrayList());
                this.listenerMap.put(switcherName, listeners);
                listeners.add(listener);
            } else {
                List<SwitcherListener> listeners = this.listenerMap.get(switcherName);
                if (!listeners.contains(listener)) {
                    listeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unRegisterListener(String switcherName, SwitcherListener listener) {
        Map<String, List<SwitcherListener>> map = this.listenerMap;
        synchronized (map) {
            if (listener == null) {
                this.listenerMap.remove(switcherName);
            } else {
                List<SwitcherListener> listeners = this.listenerMap.get(switcherName);
                listeners.remove(listener);
            }
        }
    }
}

