/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.sanitizer;

import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.sanitizer.SanitizerConfig;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.owasp.encoder.EncoderWrapper;
import org.owasp.encoder.Encoders;

public class SanitizerHandler
implements MiddlewareHandler {
    static SanitizerConfig config;
    EncoderWrapper bodyEncoder;
    EncoderWrapper headerEncoder;
    private volatile HttpHandler next;

    public SanitizerHandler() {
        config = SanitizerConfig.load();
        this.bodyEncoder = new EncoderWrapper(Encoders.forName(config.getBodyEncoder()), config.getBodyAttributesToIgnore(), config.getBodyAttributesToEncode());
        this.headerEncoder = new EncoderWrapper(Encoders.forName(config.getHeaderEncoder()), config.getHeaderAttributesToIgnore(), config.getHeaderAttributesToEncode());
    }

    @Deprecated
    public SanitizerHandler(String configName) {
        config = SanitizerConfig.load(configName);
        this.bodyEncoder = new EncoderWrapper(Encoders.forName(config.getBodyEncoder()), config.getBodyAttributesToIgnore(), config.getBodyAttributesToEncode());
        this.headerEncoder = new EncoderWrapper(Encoders.forName(config.getHeaderEncoder()), config.getHeaderAttributesToIgnore(), config.getHeaderAttributesToEncode());
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Object body;
        HeaderMap headerMap;
        if (logger.isDebugEnabled()) {
            logger.trace("SanitizerHandler.handleRequest starts.");
        }
        String method = exchange.getRequestMethod().toString();
        if (config.isHeaderEnabled() && (headerMap = exchange.getRequestHeaders()) != null) {
            for (HeaderValues values2 : headerMap) {
                ListIterator<String> itValues;
                if (values2 == null) continue;
                if (config.getHeaderAttributesToIgnore() != null) {
                    if (config.getHeaderAttributesToIgnore().stream().anyMatch(values2.getHeaderName().toString()::equalsIgnoreCase)) {
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace("Ignore header " + values2.getHeaderName().toString() + " as it is in the ignore list.");
                        continue;
                    }
                }
                if (config.getHeaderAttributesToEncode() != null) {
                    if (!config.getHeaderAttributesToEncode().stream().anyMatch(values2.getHeaderName().toString()::equalsIgnoreCase)) continue;
                    if (logger.isTraceEnabled()) {
                        logger.trace("Encode header " + values2.getHeaderName().toString() + " as it is not in the ignore list and it is in the encode list.");
                    }
                    itValues = values2.listIterator();
                    while (itValues.hasNext()) {
                        itValues.set(this.headerEncoder.applyEncoding(itValues.next()));
                    }
                    continue;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Encode header " + values2.getHeaderName().toString() + " as it is not in the ignore list and the encode list is null.");
                }
                itValues = values2.listIterator();
                while (itValues.hasNext()) {
                    itValues.set(this.headerEncoder.applyEncoding(itValues.next()));
                }
            }
        }
        if (config.isBodyEnabled() && ("POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method) || "PATCH".equalsIgnoreCase(method)) && (body = exchange.getAttachment(AttachmentConstants.REQUEST_BODY)) != null) {
            if (body instanceof List) {
                this.bodyEncoder.encodeList((List)body);
            } else if (body instanceof Map) {
                this.bodyEncoder.encodeNode((Map)body);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.trace("SanitizerHandler.handleRequest ends.");
        }
        Handler.next(exchange, this.next);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule("sanitizer", SanitizerHandler.class.getName(), config.getMappedConfig(), null);
    }

    @Override
    public void reload() {
        config = SanitizerConfig.load();
        ModuleRegistry.registerModule("sanitizer", SanitizerHandler.class.getName(), config.getMappedConfig(), null);
    }
}

