/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.sanitizer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SanitizerConfig {
    public static Logger logger = LoggerFactory.getLogger(SanitizerConfig.class);
    public static final String CONFIG_NAME = "sanitizer";
    public static final String DEFAULT_ENCODER = "javascript-source";
    public static final String BODY_ENCODER = "bodyEncoder";
    public static final String HEADER_ENCODER = "headerEncoder";
    public static final String BODY_ATTRIBUTES_TO_ENCODE = "bodyAttributesToEncode";
    public static final String BODY_ATTRIBUTES_TO_IGNORE = "bodyAttributesToIgnore";
    public static final String HEADER_ATTRIBUTES_TO_ENCODE = "headerAttributesToEncode";
    public static final String HEADER_ATTRIBUTES_TO_IGNORE = "headerAttributesToIgnore";
    private boolean enabled;
    private boolean bodyEnabled;
    private String bodyEncoder;
    private List<String> bodyAttributesToIgnore;
    private List<String> bodyAttributesToEncode;
    private boolean headerEnabled;
    private String headerEncoder;
    private List<String> headerAttributesToIgnore;
    private List<String> headerAttributesToEncode;
    private final Map<String, Object> mappedConfig;

    private SanitizerConfig(String configName) {
        this.mappedConfig = Config.getInstance().getJsonMapConfig(configName);
        this.setConfigList();
        this.setConfigData();
    }

    public static SanitizerConfig load() {
        return new SanitizerConfig(CONFIG_NAME);
    }

    @Deprecated
    public static SanitizerConfig load(String configName) {
        return new SanitizerConfig(configName);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isBodyEnabled() {
        return this.bodyEnabled;
    }

    public void setBodyEnabled(boolean bodyEnabled) {
        this.bodyEnabled = bodyEnabled;
    }

    public String getBodyEncoder() {
        return this.bodyEncoder;
    }

    public void setBodyEncoder(String bodyEncoder) {
        this.bodyEncoder = bodyEncoder;
    }

    public List<String> getBodyAttributesToIgnore() {
        return this.bodyAttributesToIgnore;
    }

    public void setBodyAttributesToIgnore(List<String> bodyAttributesToIgnore) {
        this.bodyAttributesToIgnore = bodyAttributesToIgnore;
    }

    public List<String> getBodyAttributesToEncode() {
        return this.bodyAttributesToEncode;
    }

    public void setBodyAttributesToEncode(List<String> bodyAttributesToEncode) {
        this.bodyAttributesToEncode = bodyAttributesToEncode;
    }

    public boolean isHeaderEnabled() {
        return this.headerEnabled;
    }

    public void setHeaderEnabled(boolean headerEnabled) {
        this.headerEnabled = headerEnabled;
    }

    public String getHeaderEncoder() {
        return this.headerEncoder;
    }

    public void setHeaderEncoder(String headerEncoder) {
        this.headerEncoder = headerEncoder;
    }

    public List<String> getHeaderAttributesToIgnore() {
        return this.headerAttributesToIgnore;
    }

    public void setHeaderAttributesToIgnore(List<String> headerAttributesToIgnore) {
        this.headerAttributesToIgnore = headerAttributesToIgnore;
    }

    public List<String> getHeaderAttributesToEncode() {
        return this.headerAttributesToEncode;
    }

    public void setHeaderAttributesToEncode(List<String> headerAttributesToEncode) {
        this.headerAttributesToEncode = headerAttributesToEncode;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    public void setConfigData() {
        Object object = this.mappedConfig.get("enabled");
        if (object != null) {
            if (object instanceof String) {
                this.enabled = Boolean.parseBoolean((String)object);
            } else if (object instanceof Boolean) {
                this.enabled = (Boolean)object;
            } else {
                throw new ConfigException("enabled must be a boolean value.");
            }
        }
        if ((object = this.mappedConfig.get("bodyEnabled")) != null) {
            if (object instanceof String) {
                this.bodyEnabled = Boolean.parseBoolean((String)object);
            } else if (object instanceof Boolean) {
                this.bodyEnabled = (Boolean)object;
            } else {
                object = this.mappedConfig.get("sanitizeBody");
                if (object != null) {
                    if (object instanceof String) {
                        this.bodyEnabled = Boolean.parseBoolean((String)object);
                    } else if (object instanceof Boolean) {
                        this.bodyEnabled = (Boolean)object;
                    } else {
                        throw new ConfigException("sanitizeBody must be a boolean value.");
                    }
                }
            }
        }
        if ((object = this.mappedConfig.get("headerEnabled")) != null) {
            if (object instanceof String) {
                this.headerEnabled = Boolean.parseBoolean((String)object);
            } else if (object instanceof Boolean) {
                this.headerEnabled = (Boolean)object;
            } else {
                object = this.mappedConfig.get("sanitizeHeader");
                if (object != null) {
                    if (object instanceof String) {
                        this.headerEnabled = Boolean.parseBoolean((String)object);
                    } else if (object instanceof Boolean) {
                        this.headerEnabled = (Boolean)object;
                    } else {
                        throw new ConfigException("sanitizeHeader must be a boolean value.");
                    }
                }
            }
        }
        this.bodyEncoder = (object = this.mappedConfig.get(BODY_ENCODER)) != null ? (String)object : DEFAULT_ENCODER;
        object = this.mappedConfig.get(HEADER_ENCODER);
        this.headerEncoder = object != null ? (String)object : DEFAULT_ENCODER;
    }

    private void setConfigList() {
        String s2;
        Object object;
        if (this.mappedConfig.get(BODY_ATTRIBUTES_TO_ENCODE) != null) {
            object = this.mappedConfig.get(BODY_ATTRIBUTES_TO_ENCODE);
            if (object instanceof String) {
                s2 = (String)object;
                s2 = s2.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("bodyAttributesToEncode = " + s2);
                }
                if (s2.startsWith("[")) {
                    try {
                        this.bodyAttributesToEncode = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){});
                    }
                    catch (Exception e) {
                        throw new ConfigException("could not parse the bodyAttributesToEncode json with a list of strings.");
                    }
                } else {
                    this.bodyAttributesToEncode = Arrays.asList(s2.split("\\s*,\\s*"));
                }
            } else if (object instanceof List) {
                this.bodyAttributesToEncode = (List)object;
            } else {
                throw new ConfigException("bodyAttributesToEncode list is missing or wrong type.");
            }
        }
        if (this.mappedConfig.get(BODY_ATTRIBUTES_TO_IGNORE) != null) {
            object = this.mappedConfig.get(BODY_ATTRIBUTES_TO_IGNORE);
            if (object instanceof String) {
                s2 = (String)object;
                s2 = s2.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("bodyAttributesToIgnore = " + s2);
                }
                if (s2.startsWith("[")) {
                    try {
                        this.bodyAttributesToIgnore = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){});
                    }
                    catch (Exception e) {
                        throw new ConfigException("could not parse the bodyAttributesToIgnore json with a list of strings.");
                    }
                } else {
                    this.bodyAttributesToIgnore = Arrays.asList(s2.split("\\s*,\\s*"));
                }
            } else if (object instanceof List) {
                this.bodyAttributesToIgnore = (List)object;
            } else {
                throw new ConfigException("bodyAttributesToIgnore list is missing or wrong type.");
            }
        }
        if (this.mappedConfig.get(HEADER_ATTRIBUTES_TO_ENCODE) != null) {
            object = this.mappedConfig.get(HEADER_ATTRIBUTES_TO_ENCODE);
            if (object instanceof String) {
                s2 = (String)object;
                s2 = s2.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("headerAttributesToEncode = " + s2);
                }
                if (s2.startsWith("[")) {
                    try {
                        this.headerAttributesToEncode = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){});
                    }
                    catch (Exception e) {
                        throw new ConfigException("could not parse the headerAttributesToEncode json with a list of strings.");
                    }
                } else {
                    this.headerAttributesToEncode = Arrays.asList(s2.split("\\s*,\\s*"));
                }
            } else if (object instanceof List) {
                this.headerAttributesToEncode = (List)object;
            } else {
                throw new ConfigException("headerAttributesToEncode list is missing or wrong type.");
            }
        }
        if (this.mappedConfig.get(HEADER_ATTRIBUTES_TO_IGNORE) != null) {
            object = this.mappedConfig.get(HEADER_ATTRIBUTES_TO_IGNORE);
            if (object instanceof String) {
                s2 = (String)object;
                s2 = s2.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("headerAttributesToIgnore = " + s2);
                }
                if (s2.startsWith("[")) {
                    try {
                        this.headerAttributesToIgnore = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){});
                    }
                    catch (Exception e) {
                        throw new ConfigException("could not parse the headerAttributesToIgnore json with a list of strings.");
                    }
                } else {
                    this.headerAttributesToIgnore = Arrays.asList(s2.split("\\s*,\\s*"));
                }
            } else if (object instanceof List) {
                this.headerAttributesToIgnore = (List)object;
            } else {
                throw new ConfigException("headerAttributesToIgnore list is missing or wrong type.");
            }
        }
    }
}

