/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.service.handler;

import com.hazelcast.map.IMap;
import com.networknt.config.Config;
import com.networknt.handler.LightHttpHandler;
import com.networknt.oauth.cache.CacheStartupHookProvider;
import com.networknt.oauth.service.handler.ServiceAuditHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oauth2ServiceServiceIdEndpointGetHandler
extends ServiceAuditHandler
implements LightHttpHandler {
    static final Logger logger = LoggerFactory.getLogger(Oauth2ServiceServiceIdEndpointGetHandler.class);
    static final String SERVICE_ENDPOINT_NOT_FOUND = "ERR12042";

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String serviceId;
        IMap serviceEndpoints = CacheStartupHookProvider.hz.getMap("serviceEndpoints");
        List values2 = (List)serviceEndpoints.get(serviceId = exchange.getQueryParameters().get("serviceId").getFirst());
        if (values2 == null || values2.size() == 0) {
            this.setExchangeStatus(exchange, SERVICE_ENDPOINT_NOT_FOUND, serviceId);
            this.processAudit(exchange);
            return;
        }
        exchange.getResponseHeaders().add(new HttpString("Content-Type"), "application/json");
        exchange.getResponseSender().send(Config.getInstance().getMapper().writeValueAsString(values2));
        this.processAudit(exchange);
    }
}

