/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.service.handler;

import com.hazelcast.map.IMap;
import com.networknt.handler.LightHttpHandler;
import com.networknt.oauth.cache.CacheStartupHookProvider;
import com.networknt.oauth.service.handler.ServiceAuditHandler;
import io.undertow.server.HttpServerExchange;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oauth2ServiceServiceIdEndpointDeleteHandler
extends ServiceAuditHandler
implements LightHttpHandler {
    private static Logger logger = LoggerFactory.getLogger(Oauth2ServiceServiceIdEndpointDeleteHandler.class);
    private static final String SERVICE_ENDPOINT_NOT_FOUND = "ERR12042";

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        IMap serviceEndpoints;
        String serviceId = exchange.getQueryParameters().get("serviceId").getFirst();
        if (logger.isDebugEnabled()) {
            logger.debug("Delete service endpoint for serviceId " + serviceId);
        }
        if ((serviceEndpoints = CacheStartupHookProvider.hz.getMap("serviceEndpoints")).get(serviceId) == null || ((List)serviceEndpoints.get(serviceId)).size() == 0) {
            this.setExchangeStatus(exchange, SERVICE_ENDPOINT_NOT_FOUND, serviceId);
        } else {
            serviceEndpoints.delete(serviceId);
        }
        this.processAudit(exchange);
    }
}

