/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.service.handler;

import com.hazelcast.map.IMap;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicates;
import com.hazelcast.query.impl.predicates.LikePredicate;
import com.networknt.config.JsonMapper;
import com.networknt.handler.LightHttpHandler;
import com.networknt.oauth.cache.CacheStartupHookProvider;
import com.networknt.oauth.service.handler.ServiceAuditHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oauth2ServiceGetHandler
extends ServiceAuditHandler
implements LightHttpHandler {
    static final Logger logger = LoggerFactory.getLogger(Oauth2ServiceGetHandler.class);

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        IMap services = CacheStartupHookProvider.hz.getMap("services");
        Deque<String> hostDeque = exchange.getQueryParameters().get("host");
        String host = hostDeque == null ? "%" : hostDeque.getFirst() + "%";
        int page = Integer.valueOf(exchange.getQueryParameters().get("page").getFirst());
        Deque<String> pageSizeDeque = exchange.getQueryParameters().get("pageSize");
        int pageSize = pageSizeDeque == null ? 10 : Integer.valueOf(pageSizeDeque.getFirst());
        LikePredicate likePredicate = new LikePredicate("host", host);
        PagingPredicate pagingPredicate = Predicates.pagingPredicate(likePredicate, pageSize);
        pagingPredicate.setPage(page);
        Collection values2 = services.values(pagingPredicate);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("services", values2);
        map.put("total", services.size());
        exchange.getResponseHeaders().add(Headers.CONTENT_TYPE, "application/json");
        exchange.getResponseSender().send(JsonMapper.toJson(map));
        this.processAudit(exchange);
    }
}

