/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.cache.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;

public class User
implements IdentifiedDataSerializable,
Comparable {
    private String userId = null;
    private UserTypeEnum userType = null;
    private String firstName = null;
    private String lastName = null;
    private String email = null;
    private String password = null;
    private String passwordConfirm = null;
    private String roles = null;

    public int compareTo(Object o) {
        return this.getUserId().compareTo(((User)o).getUserId());
    }

    public User userId(String userId) {
        this.userId = userId;
        return this;
    }

    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public User userType(UserTypeEnum userType) {
        this.userType = userType;
        return this;
    }

    @JsonProperty(value="userType")
    public UserTypeEnum getUserType() {
        return this.userType;
    }

    public void setUserType(UserTypeEnum userType) {
        this.userType = userType;
    }

    public User firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @JsonProperty(value="firstName")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public User lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @JsonProperty(value="lastName")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public User email(String email) {
        this.email = email;
        return this;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public User password(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public User passwordConfirm(String passwordConfirm) {
        this.passwordConfirm = passwordConfirm;
        return this;
    }

    @JsonProperty(value="passwordConfirm")
    public String getPasswordConfirm() {
        return this.passwordConfirm;
    }

    public void setPasswordConfirm(String passwordConfirm) {
        this.passwordConfirm = passwordConfirm;
    }

    public User roles(String roles) {
        this.roles = roles;
        return this;
    }

    @JsonProperty(value="roles")
    public String getRoles() {
        return this.roles;
    }

    public void setRoles(String roles) {
        this.roles = roles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.userId, user.userId) && Objects.equals((Object)this.userType, (Object)user.userType) && Objects.equals(this.firstName, user.firstName) && Objects.equals(this.lastName, user.lastName) && Objects.equals(this.email, user.email) && Objects.equals(this.password, user.password) && Objects.equals(this.passwordConfirm, user.passwordConfirm) && Objects.equals(this.roles, user.roles);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userId, this.userType, this.firstName, this.lastName, this.email, this.password, this.passwordConfirm, this.roles});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class User {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    userType: ").append(this.toIndentedString((Object)this.userType)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    passwordConfirm: ").append(this.toIndentedString(this.passwordConfirm)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.userId = in.readUTF();
        this.userType = UserTypeEnum.fromValue(in.readUTF());
        this.firstName = in.readUTF();
        this.lastName = in.readUTF();
        this.email = in.readUTF();
        this.password = in.readUTF();
        this.roles = in.readUTF();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.userId);
        out.writeUTF(this.userType.toString());
        out.writeUTF(this.firstName);
        out.writeUTF(this.lastName);
        out.writeUTF(this.email);
        out.writeUTF(this.password);
        out.writeUTF(this.roles);
    }

    @Override
    @JsonIgnore
    public int getFactoryId() {
        return 1;
    }

    @Override
    @JsonIgnore
    public int getClassId() {
        return 1;
    }

    public static enum UserTypeEnum {
        ADMIN("admin"),
        EMPLOYEE("employee"),
        CUSTOMER("customer"),
        PARTNER("partner");

        private final String value;

        private UserTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UserTypeEnum fromValue(String text) {
            for (UserTypeEnum b : UserTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

