/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.cache;

import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.networknt.oauth.cache.model.ClientDataSerializableFactory;
import com.networknt.oauth.cache.model.ProviderDataSerializableFactory;
import com.networknt.oauth.cache.model.RefreshTokenDataSerializableFactory;
import com.networknt.oauth.cache.model.ServiceDataSerializableFactory;
import com.networknt.oauth.cache.model.ServiceEndpointDataSerializableFactory;
import com.networknt.oauth.cache.model.UserDataSerializableFactory;
import com.networknt.server.StartupHookProvider;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheStartupHookProvider
implements StartupHookProvider {
    static final Logger logger = LoggerFactory.getLogger(CacheStartupHookProvider.class);
    public static HazelcastInstance hz;
    public static final String CONFIG_NAME = "hazelcast.xml";

    @Override
    public void onStartup() {
        InputStream is = com.networknt.config.Config.getInstance().getInputStreamFromFile(CONFIG_NAME);
        Config config = null;
        if (is != null) {
            logger.info("customized hazelcast.xml is loaded from config.");
            config = new XmlConfigBuilder(is).build();
        } else {
            logger.info("default hazelcast.xml is loaded.");
            config = new Config();
        }
        config.getSerializationConfig().addDataSerializableFactory(1, new UserDataSerializableFactory());
        config.getSerializationConfig().addDataSerializableFactory(2, new ClientDataSerializableFactory());
        config.getSerializationConfig().addDataSerializableFactory(3, new ServiceDataSerializableFactory());
        config.getSerializationConfig().addDataSerializableFactory(4, new RefreshTokenDataSerializableFactory());
        config.getSerializationConfig().addDataSerializableFactory(5, new ServiceEndpointDataSerializableFactory());
        config.getSerializationConfig().addDataSerializableFactory(6, new ProviderDataSerializableFactory());
        MapConfig serviceConfig = new MapConfig();
        serviceConfig.setName("services");
        NearCacheConfig serviceCacheConfig = new NearCacheConfig();
        serviceCacheConfig.getEvictionConfig();
        serviceCacheConfig.setInMemoryFormat(InMemoryFormat.OBJECT);
        serviceCacheConfig.setCacheLocalEntries(true);
        serviceConfig.setNearCacheConfig(serviceCacheConfig);
        serviceConfig.getMapStoreConfig().setEnabled(true).setClassName("com.networknt.oauth.cache.ServiceMapStore");
        config.addMapConfig(serviceConfig);
        MapConfig serviceEndpointConfig = new MapConfig();
        serviceEndpointConfig.setName("serviceEndpoints");
        NearCacheConfig serviceEndpointCacheConfig = new NearCacheConfig();
        serviceEndpointCacheConfig.getEvictionConfig();
        serviceEndpointCacheConfig.setInMemoryFormat(InMemoryFormat.OBJECT);
        serviceEndpointCacheConfig.setCacheLocalEntries(true);
        serviceEndpointConfig.setNearCacheConfig(serviceEndpointCacheConfig);
        serviceEndpointConfig.getMapStoreConfig().setEnabled(true).setClassName("com.networknt.oauth.cache.ServiceEndpointMapStore");
        config.addMapConfig(serviceEndpointConfig);
        MapConfig clientConfig = new MapConfig();
        clientConfig.setName("clients");
        NearCacheConfig clientCacheConfig = new NearCacheConfig();
        clientCacheConfig.getEvictionConfig();
        clientCacheConfig.setInMemoryFormat(InMemoryFormat.OBJECT);
        clientCacheConfig.setCacheLocalEntries(true);
        clientConfig.setNearCacheConfig(clientCacheConfig);
        clientConfig.getMapStoreConfig().setEnabled(true).setClassName("com.networknt.oauth.cache.ClientMapStore");
        config.addMapConfig(clientConfig);
        MapConfig codeConfig = new MapConfig();
        codeConfig.setName("codes");
        NearCacheConfig codeCacheConfig = new NearCacheConfig();
        codeCacheConfig.setTimeToLiveSeconds(3600000);
        codeCacheConfig.setMaxIdleSeconds(600000);
        codeCacheConfig.setInMemoryFormat(InMemoryFormat.OBJECT);
        codeCacheConfig.setCacheLocalEntries(true);
        codeConfig.setNearCacheConfig(codeCacheConfig);
        config.addMapConfig(codeConfig);
        MapConfig referenceConfig = new MapConfig();
        referenceConfig.setName("references");
        NearCacheConfig referenceCacheConfig = new NearCacheConfig();
        referenceCacheConfig.setTimeToLiveSeconds(3600000);
        referenceCacheConfig.setMaxIdleSeconds(600000);
        referenceCacheConfig.setInMemoryFormat(InMemoryFormat.OBJECT);
        referenceCacheConfig.setCacheLocalEntries(true);
        referenceConfig.setNearCacheConfig(referenceCacheConfig);
        config.addMapConfig(referenceConfig);
        MapConfig tokenConfig = new MapConfig();
        tokenConfig.setName("tokens");
        NearCacheConfig tokenCacheConfig = new NearCacheConfig();
        tokenConfig.setNearCacheConfig(tokenCacheConfig);
        tokenConfig.getMapStoreConfig().setEnabled(true).setClassName("com.networknt.oauth.cache.RefreshTokenMapStore");
        config.addMapConfig(tokenConfig);
        MapConfig userConfig = new MapConfig();
        userConfig.setName("users");
        userConfig.setBackupCount(1);
        userConfig.getMapStoreConfig().setEnabled(true).setClassName("com.networknt.oauth.cache.UserMapStore");
        userConfig.addIndexConfig(new IndexConfig(IndexType.SORTED, "email"));
        config.addMapConfig(userConfig);
        MapConfig providerConfig = new MapConfig();
        providerConfig.setName("providers");
        NearCacheConfig providerCacheConfig = new NearCacheConfig();
        providerCacheConfig.getEvictionConfig();
        providerCacheConfig.setInMemoryFormat(InMemoryFormat.OBJECT);
        providerCacheConfig.setCacheLocalEntries(true);
        providerConfig.setNearCacheConfig(providerCacheConfig);
        providerConfig.getMapStoreConfig().setEnabled(true).setClassName("com.networknt.oauth.cache.ProviderMapStore");
        config.addMapConfig(providerConfig);
        hz = Hazelcast.newHazelcastInstance(config);
    }
}

