/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.jsonoverlay;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.jsonoverlay.JsonLoader;
import com.networknt.jsonoverlay.JsonOverlay;
import com.networknt.jsonoverlay.Pair;
import com.networknt.jsonoverlay.PositionInfo;
import com.networknt.jsonoverlay.ReferenceManager;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;

public class ReferenceRegistry {
    private Map<String, ReferenceManager> managers = new HashMap<String, ReferenceManager>();
    private JsonLoader loader;
    private Map<Pair<String, String>, JsonOverlay<?>> overlaysByRef = new HashMap();
    private Map<JsonNode, Map<String, JsonOverlay<?>>> overlaysByJson = new IdentityHashMap();

    public ReferenceRegistry() {
        this(null);
    }

    public ReferenceRegistry(JsonLoader loader) {
        this.loader = loader != null ? loader : new JsonLoader();
    }

    public ReferenceManager getManager(URL baseUrl) {
        return this.managers.get(baseUrl.toString());
    }

    public void registerManager(URL baseUrl, ReferenceManager manager) {
        this.managers.put(baseUrl.toString(), manager);
    }

    public JsonNode loadDoc(URL url) throws IOException {
        return this.loader.load(url);
    }

    public JsonOverlay<?> getOverlay(String normalizedRef, String factorySig) {
        return this.overlaysByRef.get(Pair.of(normalizedRef, factorySig));
    }

    public void register(String normalizedRef, String factorySig, JsonOverlay<?> overlay) {
        this.overlaysByRef.put(Pair.of(normalizedRef, factorySig), overlay);
    }

    public JsonOverlay<?> getOverlay(JsonNode json, String factorySig) {
        Map<String, JsonOverlay<?>> overlaysBySig = this.overlaysByJson.get(json);
        return overlaysBySig != null ? overlaysBySig.get(factorySig) : null;
    }

    public void register(JsonNode json, String factorySig, JsonOverlay<?> overlay) {
        if (!(json.isMissingNode() || json.isBoolean() || json.isNull())) {
            if (!this.overlaysByJson.containsKey(json)) {
                this.overlaysByJson.put(json, new HashMap());
            }
            this.overlaysByJson.get(json).put(factorySig, overlay);
        }
    }

    public Optional<PositionInfo> getPositionInfo(String docUrl, JsonPointer pointer) {
        return this.loader.getPositionInfo(docUrl, pointer);
    }
}

