/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.http;

import com.networknt.http.HttpEntity;
import com.networknt.http.HttpMethod;
import com.networknt.http.MediaType;
import com.networknt.utility.ObjectUtils;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Deque;
import java.util.Map;

public class RequestEntity<T>
extends HttpEntity<T> {
    private final HttpMethod method;
    private final URI url;
    private final Type type;
    private Map<String, Deque<String>> queryParameters;
    private Map<String, Deque<String>> pathParameters;

    public RequestEntity(HttpMethod method, URI url) {
        this(null, null, method, url, null, null, null);
    }

    public RequestEntity(T body, HttpMethod method, URI url) {
        this(body, null, method, url, null, null, null);
    }

    public RequestEntity(T body, HttpMethod method, URI url, Type type) {
        this(body, null, method, url, type, null, null);
    }

    public RequestEntity(HeaderMap headers, HttpMethod method, URI url) {
        this(null, headers, method, url, null, null, null);
    }

    public RequestEntity(T body, HeaderMap headers, HttpMethod method, URI url) {
        this(body, headers, method, url, null, null, null);
    }

    public RequestEntity(T body, HeaderMap headers, HttpMethod method, URI url, Type type, Map<String, Deque<String>> queryParameters, Map<String, Deque<String>> pathParameters) {
        super(body, headers);
        this.method = method;
        this.url = url;
        this.type = type;
        this.queryParameters = queryParameters;
        this.pathParameters = pathParameters;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public URI getUrl() {
        if (this.url == null) {
            throw new UnsupportedOperationException();
        }
        return this.url;
    }

    public Type getType() {
        Object body;
        if (this.type == null && (body = this.getBody()) != null) {
            return body.getClass();
        }
        return this.type;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        RequestEntity otherEntity = (RequestEntity)other;
        return ObjectUtils.nullSafeEquals((Object)this.getMethod(), (Object)otherEntity.getMethod()) && ObjectUtils.nullSafeEquals(this.getUrl(), otherEntity.getUrl());
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.method);
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode(this.getUrl());
        return hashCode;
    }

    @Override
    public String toString() {
        return RequestEntity.format(this.getMethod(), this.getUrl().toString(), this.getBody(), this.getHeaders());
    }

    static <T> String format(HttpMethod httpMethod, String url, T body, HeaderMap headers) {
        StringBuilder builder = new StringBuilder("<");
        builder.append((Object)httpMethod);
        builder.append(' ');
        builder.append(url);
        builder.append(',');
        if (body != null) {
            builder.append(body);
            builder.append(',');
        }
        builder.append(headers);
        builder.append('>');
        return builder.toString();
    }

    public static BodyBuilder method(HttpMethod method, URI url, HeaderMap headers) {
        return new DefaultBodyBuilder(method, url, headers);
    }

    public Map<String, Deque<String>> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(Map<String, Deque<String>> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public Map<String, Deque<String>> getPathParameters() {
        return this.pathParameters;
    }

    public void setPathParameters(Map<String, Deque<String>> pathParameters) {
        this.pathParameters = pathParameters;
    }

    private static class DefaultBodyBuilder
    implements BodyBuilder {
        private final HttpMethod method;
        private final HeaderMap headers;
        private final URI uri;

        DefaultBodyBuilder(HttpMethod method, URI url, HeaderMap headers) {
            this.method = method;
            this.uri = url;
            this.headers = headers;
        }

        @Override
        public BodyBuilder contentLength(long contentLength) {
            this.headers.put(Headers.CONTENT_LENGTH, contentLength);
            return this;
        }

        @Override
        public BodyBuilder contentType(MediaType contentType) {
            if (contentType != null) {
                this.headers.put(Headers.CONTENT_TYPE, contentType.toString());
            } else {
                this.headers.remove(Headers.CONTENT_TYPE);
            }
            return this;
        }

        @Override
        public <T> RequestEntity<T> body(T body) {
            return this.buildInternal(body, null);
        }

        @Override
        public <T> RequestEntity<T> body(T body, Type type) {
            return this.buildInternal(body, type);
        }

        private <T> RequestEntity<T> buildInternal(T body, Type type) {
            return new RequestEntity<T>(body, this.headers, this.method, this.uri, type, null, null);
        }
    }

    public static interface BodyBuilder {
        public BodyBuilder contentLength(long var1);

        public BodyBuilder contentType(MediaType var1);

        public <T> RequestEntity<T> body(T var1);

        public <T> RequestEntity<T> body(T var1, Type var2);
    }
}

