/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.dump;

import com.networknt.dump.DumpConfig;
import com.networknt.dump.DumperFactory;
import com.networknt.dump.IRequestDumpable;
import com.networknt.dump.IResponseDumpable;
import io.undertow.server.HttpServerExchange;
import java.util.LinkedHashMap;
import java.util.Map;

class RootDumper {
    private DumperFactory dumperFactory;
    private DumpConfig dumpConfig;
    private HttpServerExchange exchange;

    public RootDumper(DumpConfig dumpConfig, HttpServerExchange exchange) {
        this.dumpConfig = dumpConfig;
        this.exchange = exchange;
        this.dumperFactory = new DumperFactory();
    }

    public void dumpRequest(Map<String, Object> result) {
        if (!this.dumpConfig.isRequestEnabled()) {
            return;
        }
        LinkedHashMap<String, Object> requestResult = new LinkedHashMap<String, Object>();
        for (IRequestDumpable dumper : this.dumperFactory.createRequestDumpers(this.dumpConfig, this.exchange)) {
            if (!dumper.isApplicableForRequest()) continue;
            dumper.dumpRequest(requestResult);
        }
        result.put("request", requestResult);
    }

    public void dumpResponse(Map<String, Object> result) {
        if (!this.dumpConfig.isResponseEnabled()) {
            return;
        }
        LinkedHashMap<String, Object> responseResult = new LinkedHashMap<String, Object>();
        for (IResponseDumpable dumper : this.dumperFactory.createResponseDumpers(this.dumpConfig, this.exchange)) {
            if (!dumper.isApplicableForResponse()) continue;
            dumper.dumpResponse(responseResult);
        }
        result.put("response", responseResult);
    }
}

