/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.dump;

import com.networknt.config.Config;
import com.networknt.dump.DumpConfig;
import com.networknt.dump.DumpHelper;
import com.networknt.dump.RootDumper;
import com.networknt.dump.StoreResponseStreamSinkConduit;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.LinkedHashMap;
import org.xnio.conduits.StreamSinkConduit;

public class DumpHandler
implements MiddlewareHandler {
    private static DumpConfig config = (DumpConfig)Config.getInstance().getJsonObjectConfig("dump", DumpConfig.class);
    private volatile HttpHandler next;

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule("dump", DumpHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache("dump"), null);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.isInIoThread()) {
            exchange.dispatch(this);
            return;
        }
        if (this.isEnabled()) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            RootDumper rootDumper = new RootDumper(config, exchange);
            rootDumper.dumpRequest(result);
            if (config.isResponseEnabled()) {
                exchange.addResponseWrapper((factory2, exchange12) -> new StoreResponseStreamSinkConduit((StreamSinkConduit)factory2.create(), exchange12));
            }
            exchange.addExchangeCompleteListener((exchange1, nextListener) -> {
                try {
                    rootDumper.dumpResponse(result);
                    DumpHelper.logResult(result, config);
                }
                catch (Throwable e) {
                    logger.error("ExchangeListener throwable", e);
                }
                finally {
                    nextListener.proceed();
                }
            });
        }
        Handler.next(exchange, this.next);
    }

    @Override
    public void reload() {
        config = (DumpConfig)Config.getInstance().getJsonObjectConfigNoCache("dump", DumpConfig.class);
        ModuleRegistry.registerModule("dump", DumpHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache("dump"), null);
        if (logger.isInfoEnabled()) {
            logger.info("DumpHandler is reloaded.");
        }
    }
}

