/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.decrypt;

import com.networknt.decrypt.Decryptor;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESSaltDecryptor
implements Decryptor {
    private static final Logger logger = LoggerFactory.getLogger(AESSaltDecryptor.class);
    private static final int ITERATIONS = 65536;
    private static final int KEY_SIZE = 256;
    private static final String STRING_ENCODING = "UTF-8";
    private static final byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private Map<String, SecretKeySpec> secretMap = new ConcurrentHashMap<String, SecretKeySpec>();
    private Cipher cipher;
    IvParameterSpec ivSpec;

    public AESSaltDecryptor() {
        try {
            this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            this.ivSpec = new IvParameterSpec(iv);
        }
        catch (Exception e) {
            logger.error("Failed to get the Cipher instance:", e);
            throw new RuntimeException("Unable to initialize", e);
        }
    }

    @Override
    public String decrypt(String input) {
        if (!input.startsWith("CRYPT")) {
            logger.error("The secret text is not started with prefix CRYPT");
            throw new RuntimeException("Unable to decrypt, input string does not start with 'CRYPT'.");
        }
        String[] parts = input.split(":");
        if (parts.length != 3) {
            logger.error("The secret text is not formatted correctly with CRYPT:salt:hash");
            throw new RuntimeException("Unable to decrypt, input string is not formatted correctly with CRYPT:salt:hash");
        }
        try {
            byte[] salt = AESSaltDecryptor.fromHex(parts[1]);
            byte[] hash = AESSaltDecryptor.fromHex(parts[2]);
            SecretKeySpec secret = this.secretMap.get(parts[1]);
            if (secret == null) {
                PBEKeySpec spec = new PBEKeySpec(this.getPassword(), salt, 65536, 256);
                SecretKeyFactory factory2 = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
                SecretKey tmp = factory2.generateSecret(spec);
                secret = new SecretKeySpec(tmp.getEncoded(), "AES");
                this.secretMap.put(parts[1], secret);
            }
            this.cipher.init(2, (Key)secret, this.ivSpec);
            return new String(this.cipher.doFinal(hash), STRING_ENCODING);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to decrypt because the decrypted password is incorrect.", e);
        }
    }

    protected char[] getPassword() {
        return "light".toCharArray();
    }

    private static byte[] fromHex(String hex) throws NoSuchAlgorithmException {
        byte[] bytes = new byte[hex.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return bytes;
    }
}

