/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.cors;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorsConfig {
    private static final Logger logger = LoggerFactory.getLogger(CorsConfig.class);
    public static final String CONFIG_NAME = "cors";
    private static final String ENABLED = "enabled";
    private static final String ALLOWED_ORIGINS = "allowedOrigins";
    private static final String ALLOWED_METHODS = "allowedMethods";
    private Map<String, Object> mappedConfig;
    private final Config config = Config.getInstance();
    boolean enabled;
    List<String> allowedOrigins;
    List<String> allowedMethods;

    private CorsConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
        this.setConfigList();
    }

    private CorsConfig() {
        this(CONFIG_NAME);
    }

    public static CorsConfig load(String configName) {
        return new CorsConfig(configName);
    }

    public static CorsConfig load() {
        return new CorsConfig();
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
        this.setConfigList();
    }

    public void reload(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
        this.setConfigList();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(List allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public List getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(List allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    Config getConfig() {
        return this.config;
    }

    private void setConfigData() {
        Object object;
        if (this.getMappedConfig() != null && (object = this.getMappedConfig().get(ENABLED)) != null) {
            this.enabled = Config.loadBooleanValue(ENABLED, object);
        }
    }

    private void setConfigList() {
        List prefixes;
        String s2;
        Object object;
        if (this.mappedConfig != null && this.mappedConfig.get(ALLOWED_ORIGINS) != null) {
            object = this.mappedConfig.get(ALLOWED_ORIGINS);
            this.allowedOrigins = new ArrayList<String>();
            if (object instanceof String) {
                s2 = (String)object;
                s2 = s2.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("s = " + s2);
                }
                if (s2.startsWith("[")) {
                    try {
                        this.allowedOrigins = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){});
                    }
                    catch (Exception e) {
                        throw new ConfigException("could not parse the skipPathPrefixes json with a list of strings.");
                    }
                } else {
                    this.allowedOrigins = Arrays.asList(s2.split("\\s*,\\s*"));
                }
            } else if (object instanceof List) {
                prefixes = (List)object;
                prefixes.forEach(item -> this.allowedOrigins.add((String)item));
            } else {
                throw new ConfigException("allowedOrigins must be a string or a list of strings.");
            }
        }
        if (this.mappedConfig != null && this.mappedConfig.get(ALLOWED_METHODS) != null) {
            object = this.mappedConfig.get(ALLOWED_METHODS);
            this.allowedMethods = new ArrayList<String>();
            if (object instanceof String) {
                s2 = (String)object;
                s2 = s2.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("s = " + s2);
                }
                if (s2.startsWith("[")) {
                    try {
                        this.allowedMethods = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<String>>(){});
                    }
                    catch (Exception e) {
                        throw new ConfigException("could not parse the skipPathPrefixes json with a list of strings.");
                    }
                } else {
                    this.allowedMethods = Arrays.asList(s2.split("\\s*,\\s*"));
                }
            } else if (object instanceof List) {
                prefixes = (List)object;
                this.allowedMethods.addAll(prefixes);
            } else {
                throw new ConfigException("allowedMethods must be a string or a list of strings.");
            }
        }
    }
}

