/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.circuitbreaker;

import com.networknt.client.ClientConfig;
import com.networknt.client.circuitbreaker.State;
import io.undertow.client.ClientResponse;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class CircuitBreaker {
    private Supplier<CompletableFuture<ClientResponse>> supplier;
    private static AtomicInteger timeoutCount;
    private long lastErrorTime;

    public CircuitBreaker(Supplier<CompletableFuture<ClientResponse>> supplier) {
        this.supplier = supplier;
        timeoutCount = new AtomicInteger(0);
    }

    public ClientResponse call() throws TimeoutException, ExecutionException, InterruptedException {
        State state = this.checkState();
        try {
            if (State.OPEN == state) {
                throw new IllegalStateException("circuit is opened.");
            }
            ClientResponse clientResponse = this.supplier.get().get(ClientConfig.get().getTimeout(), TimeUnit.MILLISECONDS);
            timeoutCount = new AtomicInteger(0);
            return clientResponse;
        }
        catch (InterruptedException | ExecutionException e) {
            throw e;
        }
        catch (TimeoutException e) {
            this.recordTimeout();
            throw e;
        }
    }

    private State checkState() {
        boolean isExtrapolatedErrorThreshold;
        ClientConfig clientConfig = ClientConfig.get();
        boolean isExtrapolatedResetTimeout = Instant.now().toEpochMilli() - this.lastErrorTime > (long)clientConfig.getResetTimeout();
        boolean bl = isExtrapolatedErrorThreshold = timeoutCount.get() >= clientConfig.getErrorThreshold();
        if (isExtrapolatedErrorThreshold && isExtrapolatedResetTimeout) {
            return State.HALF_OPEN;
        }
        if (timeoutCount.get() >= clientConfig.getErrorThreshold()) {
            return State.OPEN;
        }
        return State.CLOSE;
    }

    private void recordTimeout() {
        timeoutCount.getAndIncrement();
        this.lastErrorTime = Instant.now().toEpochMilli();
    }
}

