/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.cache;

import com.networknt.cache.CacheConfig;
import com.networknt.cache.CacheItem;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.ModuleRegistry;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CacheManager {
    public static final Logger logger = LoggerFactory.getLogger(CacheManager.class);

    public static CacheManager getInstance() {
        CacheConfig config = CacheConfig.load();
        ModuleRegistry.registerModule("cache", CacheManager.class.getName(), config.getMappedConfig(), null);
        List<CacheItem> caches = config.getCaches();
        if (caches != null && !caches.isEmpty()) {
            CacheManager cacheManager = SingletonServiceFactory.getBean(CacheManager.class);
            if (cacheManager != null) {
                for (CacheItem cacheItem : caches) {
                    cacheManager.addCache(cacheItem.getCacheName(), cacheItem.getMaxSize(), cacheItem.getExpiryInMinutes());
                }
            } else {
                logger.error("CacheManager implementation is not found in the service.yml");
            }
            return cacheManager;
        }
        logger.error("No cache is configured in cache.yml");
        return null;
    }

    public void addCache(String var1, long var2, long var4);

    public void put(String var1, String var2, Object var3);

    public Object get(String var1, String var2);

    public void delete(String var1, String var2);

    public void removeCache(String var1);

    public int getSize(String var1);
}

