/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.apikey;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.apikey.ApiKey;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiKeyConfig {
    private static final Logger logger = LoggerFactory.getLogger(ApiKeyConfig.class);
    public static final String CONFIG_NAME = "apikey";
    public static final String ENABLED = "enabled";
    public static final String HASH_ENABLED = "hashEnabled";
    public static final String PATH_PREFIX = "pathPrefix";
    public static final String HEADER_NAME = "headerName";
    public static final String API_KEY = "apiKey";
    public static final String PATH_PREFIX_AUTHS = "pathPrefixAuths";
    boolean enabled;
    boolean hashEnabled;
    List<ApiKey> pathPrefixAuths;
    private final Config config = Config.getInstance();
    private Map<String, Object> mappedConfig;

    private ApiKeyConfig() {
        this(CONFIG_NAME);
    }

    private ApiKeyConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
        this.setConfigList();
    }

    public static ApiKeyConfig load() {
        return new ApiKeyConfig();
    }

    public static ApiKeyConfig load(String configName) {
        return new ApiKeyConfig(configName);
    }

    void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
        this.setConfigList();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isHashEnabled() {
        return this.hashEnabled;
    }

    public void setHashEnabled(boolean hashEnabled) {
        this.hashEnabled = hashEnabled;
    }

    public List<ApiKey> getPathPrefixAuths() {
        return this.pathPrefixAuths;
    }

    public void setPathPrefixAuths(List<ApiKey> pathPrefixAuths) {
        this.pathPrefixAuths = pathPrefixAuths;
    }

    private void setConfigData() {
        Object object = this.mappedConfig.get(ENABLED);
        if (object != null) {
            this.enabled = Config.loadBooleanValue(ENABLED, object);
        }
        if ((object = this.mappedConfig.get(HASH_ENABLED)) != null) {
            this.hashEnabled = Config.loadBooleanValue(HASH_ENABLED, object);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setConfigList() {
        if (this.mappedConfig.get(PATH_PREFIX_AUTHS) == null) return;
        Object object = this.mappedConfig.get(PATH_PREFIX_AUTHS);
        this.pathPrefixAuths = new ArrayList<ApiKey>();
        if (object instanceof String) {
            String s2 = (String)object;
            s2 = s2.trim();
            if (logger.isTraceEnabled()) {
                logger.trace("pathPrefixAuth s = " + s2);
            }
            if (!s2.startsWith("[")) throw new ConfigException("pathPrefixAuth must be a list of string object map.");
            try {
                this.pathPrefixAuths = Config.getInstance().getMapper().readValue(s2, new TypeReference<List<ApiKey>>(){});
                return;
            }
            catch (Exception e) {
                throw new ConfigException("could not parse the pathPrefixAuth json with a list of string and object.");
            }
        } else {
            if (!(object instanceof List)) throw new ConfigException("pathPrefixAuth must be a list of string object map.");
            List values2 = (List)object;
            for (Map value : values2) {
                ApiKey apiKey = new ApiKey();
                apiKey.setPathPrefix((String)value.get(PATH_PREFIX));
                apiKey.setHeaderName((String)value.get(HEADER_NAME));
                apiKey.setApiKey((String)value.get(API_KEY));
                this.pathPrefixAuths.add(apiKey);
            }
        }
    }
}

